/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.icu.text.SymbolTable;
import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * <  >.
 *
 * @author liulongbing
 * @create 2023/11/1
 * @since
 */
public class JsonUtil {

    //    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_TYPE = "datetime";

    public static void mergeJSONObject(final JSONObject source, final JSONObject dest) throws JSONException {
        Iterator<String> sourceIterator = source.keys();
        while (sourceIterator.hasNext()) {
            String key = sourceIterator.next();
            Object value = source.get(key);
            if (value instanceof JSONArray) {
                dest.put(key, formatJSONArray(( JSONArray ) value));
            } else if (value instanceof JSONObject) {
                dest.put(key, formatJSONObject(( JSONObject ) value));
            } else {
                dest.put(key, value);
            }
        }
    }

    private static boolean isNeedApply(Object s, Object d) {
        if (null == d) {
            return true;
        }
        if (null == s) {
            return false;
        }
        return TextUtils.equals(s.getClass().getName(), d.getClass().getName());
    }


    public static JSONArray formatJSONArray(JSONArray jsonArr) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < jsonArr.length(); i++) {
            Object value = jsonArr.opt(i);
            if (value != null) {
                if (value instanceof JSONArray) {
                    result.put(formatJSONArray(( JSONArray ) value));
                } else if (value instanceof JSONObject) {
                    JSONObject newObject = formatJSONObject(( JSONObject ) value);
                    result.put(newObject);
                } else {
                    result.put(value);
                }
            }

        }
        return result;
    }

    public static JSONObject formatJSONObject(JSONObject jsonObject) {
        JSONObject result = new JSONObject();
        Iterator<String> iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = null;
            try {
                value = jsonObject.get(key);
                if (value instanceof JSONArray) {
                    result.put(key, formatJSONArray(( JSONArray ) value));
                } else if (value instanceof JSONObject) {
                    result.put(key, formatJSONObject(( JSONObject ) value));
                } else {
                    result.put(key, value);
                }
            } catch (JSONException exception) {
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static void mergeMapTpJson(Map<String, Object> map, JSONObject dest) throws JSONException {
        if (null == map || dest == null) return;
        for (String s : map.keySet()) {
            Object value = map.get(s);
            if (value instanceof Map) {
                dest.put(s, mapToJson(( Map<String, Object> ) value));
            } else if (value instanceof List) {
                dest.put(s, listToJsonArray(( List<Object> ) value));
            } else {
                dest.put(s, value);
            }
        }
    }

    public static void mergeMap(Map<String, String> map, Map<String, String> dest) throws JSONException {
        if (null == map || dest == null) return;
        for (String s : map.keySet()) {
            String value = map.get(s);
            dest.put(s, value);
        }
    }

    public static void mergeJsonToMap(JSONObject json, Map<String, String> dest) throws JSONException {
        if (null == json || dest == null) return;
        Iterator<String> iterator = json.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = json.opt(key);
            if (null != value) {
                dest.put(key, value.toString());
            }
        }
    }

    private static JSONObject mapToJson(Map<String, Object> map) {
        JSONObject json = new JSONObject();
        if (map != null) {
            try {
                for (String s : map.keySet()) {
                    Object value = map.get(s);
                    if (value instanceof Map) {
                        json.put(s, mapToJson(( Map<String, Object> ) value));
                    } else if (value instanceof List) {
                        json.put(s, listToJsonArray(( List<Object> ) value));
                    } else {
                        json.put(s, value);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return json;
    }

    private static JSONArray listToJsonArray(List<Object> list) {
        JSONArray array = new JSONArray();
        if (list != null) {
            try {
                for (Object o : list) {
                    array.put(o);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return array;
    }

    public static String getJsonFromAssets(String fileName, Context context) {
        StringBuilder stringBuilder = new StringBuilder();

        try {
            AssetManager assetManager = context.getAssets();
            BufferedReader bf = new BufferedReader(new InputStreamReader(assetManager.open(fileName)));

            String line;
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        } catch (IOException var6) {
            var6.printStackTrace();
        }

        return stringBuilder.toString();
    }

    public static String getJsonFromPath(String filePath) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bf = new BufferedReader(new FileReader(filePath));
            String line;
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        } catch (IOException var6) {
            var6.printStackTrace();
        }

        return stringBuilder.toString();
    }

    public static void parseJsonConfig(JSONObject configJson, JSONObject typeJson) {
        if (null == typeJson || null == configJson) return;
        Iterator<String> keys = typeJson.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = typeJson.optString(key);
            if (TextUtils.equals(value, DATE_TYPE)) {
                String configValue = configJson.optString(key);
                SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_PATTERN, Locale.CHINA);
                try {
                    Date date = dateFormat.parse(configValue);
                    configJson.put(key, date);
                } catch (ParseException | JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void parseMapConfig(JSONObject configJson, JSONObject typeJson) {
        if (null == typeJson || null == configJson) return;
        Iterator<String> keys = typeJson.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = typeJson.optString(key);
            if (TextUtils.equals(value, DATE_TYPE)) {
                String configValue = configJson.optString(key);
                SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_PATTERN, Locale.CHINA);
                try {
                    Date date = dateFormat.parse(configValue);
                    configJson.put(key, date);
                } catch (ParseException | JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JSONObject parseConfigToJson(JSONObject json) {
        JSONObject newJson = new JSONObject();
        if (json == null) return newJson;
        try {
            JSONObject configJson = new JSONObject();
            JSONObject typeJson = new JSONObject();
            Iterator<String> keys = json.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                Object value = json.opt(key);
                if (value instanceof Date) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_PATTERN, Locale.CHINA);
                    String dateFormatString = dateFormat.format(( Date ) value);
                    configJson.put(key, dateFormatString);
                    typeJson.put(key, DATE_TYPE);
                } else {
                    configJson.put(key, value);
                }
            }
            newJson.put("config", configJson);
            newJson.put("type", typeJson);
        } catch (Exception e) {

        }
        return newJson;
    }


}
