/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.remoteconfig.utils;
import org.json.JSONObject;
import cn.thinkingdata.core.router.TRouter;
import cn.thinkingdata.core.router.TRouterMap;
import cn.thinkingdata.core.router.provider.IAnalyticsProvider;
/**
 * @author liulongbing
 * @since 2024/5/10
 */
public class AnalyticUtil {

    private static final int PLUGIN_FROM = 3;

    private static final String CLIENT_DEBUG_EVENT = "te_ops_client_debug_test";
    private static final String CLIENT_RISK_EVENT = "te_ops_client_risk_record";

    public static IAnalyticsProvider getAnalyticProvider() {
        try {
            return ( IAnalyticsProvider ) TRouter.getInstance().build(TRouterMap.ANALYTIC_PROVIDER_ROUTE_PATH).navigation();
        } catch (Exception ignored) {
            return null;
        }
    }

    public static long getCurrentTimeStamp() {
        IAnalyticsProvider provider = ( IAnalyticsProvider ) TRouter.getInstance().build(TRouterMap.ANALYTIC_PROVIDER_ROUTE_PATH).navigation();
        if (provider != null) {
            return provider.getCurrentTimeStamp().first;
        }
        return System.currentTimeMillis();
    }

    public static void trackDebugFailEvent(String appId, int failCode) {
        try {
            JSONObject properties = new JSONObject();
            JSONObject resultJson = new JSONObject();
            resultJson.put("business_type", "1");
            resultJson.put("is_pull_success", false);
            resultJson.put("pull_fail_code", failCode);
            properties.put("#rcc_pull_result", resultJson);
            TRouter.getInstance().build(TRouterMap.ANALYTIC_ROUTE_PATH)
                    .withAction("track")
                    .withString("eventName", CLIENT_DEBUG_EVENT)
                    .withString("appId", appId)
                    .withInt("from", PLUGIN_FROM)
                    .withObject("properties", properties)
                    .withInt("trackDebugType", 2)
                    .navigation();
        } catch (Exception ignore) {
        }
    }

    public static void trackClientDebugEvent(String appId, JSONObject configJson) {
        try {
            JSONObject properties = new JSONObject();
            JSONObject resultJson = new JSONObject();
            resultJson.put("business_type", "2");
            resultJson.put("is_pull_success", true);
            resultJson.put("ops_config_content", configJson);
            properties.put("#rcc_pull_result", resultJson);
            TRouter.getInstance().build(TRouterMap.ANALYTIC_ROUTE_PATH)
                    .withAction("track")
                    .withString("eventName", CLIENT_DEBUG_EVENT)
                    .withString("appId", appId)
                    .withInt("from", PLUGIN_FROM)
                    .withObject("properties", properties)
                    .withInt("trackDebugType", 2)
                    .navigation();
        } catch (Exception ignore) {
        }
    }

    public static void trackRiskEvent(String appId, String type) {
        try {
            JSONObject properties = new JSONObject();
            properties.put("#ops_risk_type", type);
            properties.put("#ops_business_type", "2");
            TRouter.getInstance().build(TRouterMap.ANALYTIC_ROUTE_PATH)
                    .withAction("track")
                    .withString("eventName", CLIENT_RISK_EVENT)
                    .withString("appId", appId)
                    .withInt("from", PLUGIN_FROM)
                    .withObject("properties", properties)
                    .withInt("trackDebugType", 0)
                    .navigation();
        } catch (Exception ignore) {
        }
    }
}
