/*
 * Copyright (C) 2025 ThinkingData
 */
package cn.thinkingdata.remoteconfig.sp;

import android.content.SharedPreferences;

import java.util.concurrent.Future;

import cn.thinkingdata.core.sp.SharedPreferencesStorage;

/**
 *
 * @author liulongbing
 * @since  2025/2/12
 */
public class StorageLocalUserId extends SharedPreferencesStorage<String> {

    public StorageLocalUserId(Future<SharedPreferences> future) {
        super(future, "local_user_id");
    }

    @Override
    public void save(SharedPreferences.Editor editor, String userId) {
        editor.putString(this.storageKey, userId);
        editor.apply();
    }

    @Override
    public void load(SharedPreferences sharedPreferences) {
        this.data = sharedPreferences.getString(this.storageKey, "");
    }
}
