/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.sp;

import android.content.SharedPreferences;

import java.util.concurrent.Future;

import cn.thinkingdata.core.sp.SharedPreferencesStorage;

/**
 * @author liulongbing
 * @since 2023/11/1
 */
public class StorageLastFetchTime extends SharedPreferencesStorage<Long> {

    public StorageLastFetchTime(Future<SharedPreferences> future, String s) {
        super(future, "last_fetch_time_" + s);
    }

    @Override
    protected void save(SharedPreferences.Editor editor, Long aLong) {
        editor.putLong(this.storageKey, aLong);
        editor.apply();
    }

    @Override
    public void load(SharedPreferences sharedPreferences) {
        this.data = sharedPreferences.getLong(this.storageKey, 0L);
    }

}
