/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.remoteconfig.user;

import android.database.Cursor;

/**
 * <  >.
 *
 * @author liulongbing
 * @create 2024/3/7
 * @since
 */
public class ClientUser {

    public String appId;
    public String accountId;
    public String distinctId;
    public String clientUserId;
    public long updateTimeStamp;

    public static ClientUser parseCursor(Cursor cursor) {
        ClientUser user = null;
        if (cursor != null) {
            if (cursor.moveToNext()) {
                user = new ClientUser();
                int appIdIndex = cursor.getColumnIndex(ClientUserIdDataBaseHelper.KEY_APP_ID);
                user.appId = cursor.getString(appIdIndex);
                int accountIdIndex = cursor.getColumnIndex(ClientUserIdDataBaseHelper.KEY_ACCOUNT_ID);
                user.accountId = cursor.getString(accountIdIndex);
                int distinctIdIndex = cursor.getColumnIndex(ClientUserIdDataBaseHelper.KEY_DISTINCT_ID);
                user.distinctId = cursor.getString(distinctIdIndex);
                int cUidIndex = cursor.getColumnIndex(ClientUserIdDataBaseHelper.KEY_CLIENT_USER_ID);
                user.clientUserId = cursor.getString(cUidIndex);
                int updateTimeIndex = cursor.getColumnIndex(ClientUserIdDataBaseHelper.KEY_UPDATE_TIME);
                user.updateTimeStamp = cursor.getLong(updateTimeIndex);
            }
        }
        return user;
    }
}
