/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.sp;

import android.content.SharedPreferences;

import java.util.concurrent.Future;

import cn.thinkingdata.core.sp.SharedPreferencesStorage;

/**
 * <  >.
 *
 * @author liulongbing
 * @create 2023/12/5
 * @since
 */
public class StorageUserId extends SharedPreferencesStorage<Long> {

    public StorageUserId(Future<SharedPreferences> future) {
        super(future, "user_id");
    }

    @Override
    public void save(SharedPreferences.Editor editor, Long installTime) {
        editor.putLong(this.storageKey, installTime);
        editor.apply();
    }

    @Override
    public void load(SharedPreferences sharedPreferences) {
        this.data = sharedPreferences.getLong(this.storageKey, -1L);
    }
}
