/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.sp;

import android.content.Context;

import cn.thinkingdata.core.sp.AbstractStoragePlugin;
import cn.thinkingdata.core.sp.SharedPreferencesStorage;

/**
 * @author liulongbing
 * @create 2023/11/1
 * @since
 */
public class RemoteConfigStoragePlugin extends AbstractStoragePlugin {

    public static final String PREFERENCE_NAME = "td.remote.config.";

    private StorageLastFetchConfig storageLastFetchConfig;
    private StorageDefaultConfig storageDefaultConfig;
    private StorageLastFetchTime storageLastFetchTime;

    public RemoteConfigStoragePlugin(Context context, String appId, String code) {
        super(context, PREFERENCE_NAME + appId);
        this.loadStorage(context, code);
    }

    private void loadStorage(Context context, String code) {
        storageLastFetchConfig = new StorageLastFetchConfig(storedSharedPrefs, code);
        storageDefaultConfig = new StorageDefaultConfig(storedSharedPrefs, code);
        storageLastFetchTime = new StorageLastFetchTime(storedSharedPrefs, code);
    }

    @Override
    protected void createStorage(Context context) {
    }

    @Override
    protected <T> SharedPreferencesStorage<T> getSharePreferenceStorage(int i) {
        switch (i) {
            case LocalStorageType.LAST_FETCH_CONFIG:
                return ( SharedPreferencesStorage<T> ) storageLastFetchConfig;
            case LocalStorageType.DEFAULT_CONFIG:
                return ( SharedPreferencesStorage<T> ) storageDefaultConfig;
            case LocalStorageType.LAST_FETCH_TIME:
                return ( SharedPreferencesStorage<T> ) storageLastFetchTime;
        }
        return null;
    }
}
