/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.sp;

import android.content.Context;

import cn.thinkingdata.core.sp.AbstractStoragePlugin;
import cn.thinkingdata.core.sp.SharedPreferencesStorage;

/**
 * @author liulongbing
 * @create 2023/12/5
 * @since
 */
public class AppStoragePlugin extends AbstractStoragePlugin {
    private static final String PREFERENCE_NAME = "td.app.config.";
    private StorageUserId storageUserId;
    private StorageUserIdExpiredTime storageUserIdExpiredTime;
    private StorageLastClientUserId storageFetchClientUserId;
    private StorageLastAccountId storageLastAccountId;
    private StorageLastModify storageLastModify;

    public AppStoragePlugin(Context context, String appId) {
        super(context, PREFERENCE_NAME + appId);
    }

    @Override
    protected void createStorage(Context context) {
        storageUserId = new StorageUserId(storedSharedPrefs);
        storageUserIdExpiredTime = new StorageUserIdExpiredTime(storedSharedPrefs);
        storageFetchClientUserId = new StorageLastClientUserId(storedSharedPrefs);
        storageLastAccountId = new StorageLastAccountId(storedSharedPrefs);
        storageLastModify = new StorageLastModify(storedSharedPrefs);
    }

    @Override
    protected <T> SharedPreferencesStorage<T> getSharePreferenceStorage(int i) {
        switch (i) {
            case LocalStorageType.USER_ID:
                return ( SharedPreferencesStorage<T> ) storageUserId;
            case LocalStorageType.USER_ID_EXPIRED:
                return ( SharedPreferencesStorage<T> ) storageUserIdExpiredTime;
            case LocalStorageType.LAST_FETCH_CLIENT_USER:
                return ( SharedPreferencesStorage<T> ) storageFetchClientUserId;
            case LocalStorageType.LAST_ACCOUNT_ID:
                return ( SharedPreferencesStorage<T> ) storageLastAccountId;
            case LocalStorageType.LAST_MODIFY_FILE:
                return ( SharedPreferencesStorage<T> ) storageLastModify;
        }
        return null;
    }
}
