/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.remoteconfig.receiver;

import org.json.JSONObject;

import cn.thinkingdata.core.receiver.TDObserver;
import cn.thinkingdata.remoteconfig.core.TDRemoteInstance;

/**
 * @author liulongbing
 * @since 2024/1/12
 */
public class TDRemoteConfigObserver implements TDObserver {

    @Override
    public void onSdkInitReceived(String s) {

    }

    @Override
    public void onLoginReceived(String s, String s1, String s2) {
        doChangeAccount(s, s1, s2);
    }

    @Override
    public void onDistinctIdReceived(String s, String s1, String s2) {
        doChangeAccount(s, s1, s2);
    }

    @Override
    public void onLogoutReceived(String s, String s1) {
        doChangeAccount("", s, s1);
    }

    private void doChangeAccount(String accountId, String distinctId, String appId) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
        if (instance != null) {
            instance.doChangeAccount(accountId, distinctId);
        }
    }

    @Override
    public void onDataEnqueued(String s, JSONObject jsonObject) {

    }

    @Override
    public void onTimeCalibrated() {

    }
}
