/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.remoteconfig.plugin;

import android.content.Context;
import android.text.TextUtils;

import java.util.List;

import cn.thinkingdata.core.TDSettings;
import cn.thinkingdata.core.router.TRouterMap;
import cn.thinkingdata.core.router.plugin.IPlugin;
import cn.thinkingdata.core.router.plugin.MethodCall;
import cn.thinkingdata.remoteconfig.TDRemoteConfig;
import cn.thinkingdata.remoteconfig.TDRemoteConfigSettings;
import cn.thinkingdata.ta_apt.TRoute;

/**
 * @author liulongbing
 * @since 2024/5/20
 */
@TRoute(path = TRouterMap.RCC_PLUGIN_ROUTE_PATH)
public class RemoteConfigPlugin implements IPlugin {

    @Override
    public void onMethodCall(MethodCall methodCall) {
        try {
            String methodName = methodCall.method;
            if (TextUtils.equals(methodName, "init")) {
                Context context = methodCall.argument("context");
                List<TDSettings> list = methodCall.argument("settings");
                if (context == null || list == null) return;
                for (TDSettings settings : list) {
                    TDRemoteConfigSettings setting = new TDRemoteConfigSettings();
                    setting.appId = settings.appId;
                    setting.serverUrl = settings.serverUrl;
                    setting.setCustomFetchParams(settings.rccFetchParams);
                    TDRemoteConfig.enableLog(settings.enableLog);
                    TDRemoteConfig.init(context, setting);
                }
            }
        } catch (Exception ignore) {
        }
    }
}
