package cn.thinkingdata.installReferrer.utils;


import android.content.Context;
import android.content.SharedPreferences;

public class SpUtils {

    public static final String KEY_REFERRER_CONFIG = "td_referrer";

    private SharedPreferences sp;
    private static volatile SpUtils instance;

    private SpUtils(Context context) {
        if (sp == null) {
            sp = context.getSharedPreferences("td_referrer_config_sp", Context.MODE_PRIVATE);
        }
    }

    public static SpUtils getInstance(Context context) {
        if (instance == null) {
            synchronized (SpUtils.class) {
                if (instance == null) {
                    instance = new SpUtils(context);
                }
            }
        }
        return instance;
    }

    public void putString(String key, String value) {
        if (sp == null) return;
        sp.edit().putString(key, value).apply();
    }

    public String getString(String key, String defValue) {
        if (sp == null) return defValue;
        return sp.getString(key, defValue);
    }
}

