package cn.thinkingdata.installReferrer.plugin;

import android.content.Context;
import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import cn.thinkingdata.analytics.TDAnalyticsAPI;
import cn.thinkingdata.core.router.plugin.IPlugin;
import cn.thinkingdata.core.router.plugin.MethodCall;
import cn.thinkingdata.core.utils.TDLog;
import cn.thinkingdata.installReferrer.utils.LogUtils;
import cn.thinkingdata.installReferrer.utils.SpUtils;
import cn.thinkingdata.installReferrer.manager.InstallReferrerManager;
import cn.thinkingdata.installReferrer.model.ReferrerInfo;
import cn.thinkingdata.ta_apt.TRoute;

@TRoute(path = "/thingkingdata/install/referrer")
public class InstallReferrerPlugin implements IPlugin {
    private static final String TAG = LogUtils.INSTALL_REFERRER_TAG + InstallReferrerPlugin.class.getSimpleName();
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 1,
            5L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>());

    @Override
    public void onMethodCall(MethodCall call) {
        try {
            threadPoolExecutor.submit(() -> {
                if ("getInstallReferrer".equals(call.method)) {
                    Context context = call.argument("context");
                    if (context == null) {
                        TDLog.d(TAG, "referrer context is null");
                        return;
                    }
                    if (TextUtils.isEmpty(SpUtils.getInstance(context).getString(SpUtils.KEY_REFERRER_CONFIG, ""))) {
                        ReferrerInfo info = InstallReferrerManager.getInfo(context);
                        if (info != null && info.getBaseReferrer() != null) {
                            JSONObject jsonObject = new JSONObject();
                            String referrerJson;
                            try {
                                referrerJson = info.getBaseReferrer().toJsonString();
                                jsonObject.put("#start_reason", referrerJson);
                                TDLog.d(TAG, referrerJson);
                            } catch (JSONException e) {
                                TDLog.d(TAG, "referrer info cast to json throw a Exception, e = " + e.getMessage());
                                return;
                            }
                            if (call.argument("appId") != null) {
                                TDLog.d(TAG, "referrer track start");
                                TDAnalyticsAPI.track("ta_ad_install", jsonObject, call.argument("appId"));
                                SpUtils.getInstance(context).putString(SpUtils.KEY_REFERRER_CONFIG, referrerJson);
                            } else {
                                TDLog.d(TAG, "referrer appId is null");
                            }
                        }
                    } else {
                        TDLog.d(TAG, "app is not first start and not update");
                    }
                }
            }).get();
        } catch (RejectedExecutionException ignore) {
        } catch (Throwable e) {
            TDLog.d(TAG, "referrer error = " + e.getMessage());
        }
    }
}
