package cn.thinkingdata.installReferrer.platform;

import android.content.Context;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import cn.thinkingdata.installReferrer.model.BaseReferrer;
import cn.thinkingdata.installReferrer.utils.HasValueUtils;
import cn.thinkingdata.installReferrer.utils.LogUtils;
import cn.thinkingdata.installReferrer.model.ReferrerInfo;

public abstract class BasePlatform implements PlatformManager {
    protected final static int waitTime = 3000;
    protected final static String TAG = "BasePlatform";
    protected final BlockingQueue<ReferrerInfo> referrerDetailsHolder = new LinkedBlockingQueue<>(1);

    public abstract ReferrerInfo getReferrer(Context context);

    protected static void offerError(String error, BlockingQueue<ReferrerInfo> referrerDetailsHolder) {
        referrerDetailsHolder.offer(new ReferrerInfo(error));
        LogUtils.e(TAG, error);
    }

    protected void getInstallReferrerError(String error) {
        offerError(TAG + " getInstallReferrer: " + error, referrerDetailsHolder);
    }

    protected void featureNotSupported() {
        offerError(TAG + " onInstallReferrerSetupFinished: FEATURE_NOT_SUPPORTED",
                referrerDetailsHolder);
    }

    protected void serviceUnavailable() {
        offerError(TAG + " onInstallReferrerSetupFinished: SERVICE_UNAVAILABLE",
                referrerDetailsHolder);
    }

    protected void onInstallReferrerSetupError(String error) {
        offerError(TAG + " onInstallReferrerSetupError: " + error, referrerDetailsHolder);
    }

    protected ReferrerInfo checkReferrer(ReferrerInfo referrer) {
        try {
            if (HasValueUtils.isHasValue(referrer)) {
                BaseReferrer baseReferrer = referrer.getBaseReferrer();
                if (baseReferrer.getInstallBeginTimestampSeconds() != 0 ||
                        baseReferrer.getReferrerClickTimestampSeconds() != 0 ||
                        baseReferrer.getInstallBeginTimestampServerSeconds() != 0 ||
                        baseReferrer.getReferrerClickTimestampServerSeconds() != 0 ||
                        baseReferrer.getInstallBeginTimestampMillisecond() != 0 ||
                        baseReferrer.getReferrerClickTimestampMillisecond() != 0) {
                    return referrer;
                }
            }
        } catch (Throwable e) {
            LogUtils.e(TAG, TAG + " Referrer get failed, throw " + e.getMessage());
            return null;
        }
        return null;
    }

    @Override
    public ReferrerInfo getReferrerInfo(Context context, String fbAppId, String key) {
        return null;
    }
}
