package cn.thinkingdata.installReferrer.model;

import org.json.JSONException;

import java.io.Serializable;
import java.net.URLDecoder;

public abstract class BaseReferrer implements Serializable {

    public BaseReferrer(String referrer) {
        this.referrer = URLDecoder.decode(referrer);
    }

    public String referrer;

    public String getReferrer() {
        return referrer;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public abstract String toJsonString() throws JSONException;

    public long installBeginTimestampSeconds;

    public long referrerClickTimestampSeconds;

    public long installBeginTimestampServerSeconds;

    public long referrerClickTimestampServerSeconds;

    public long installBeginTimestampMillisecond;

    public long referrerClickTimestampMillisecond;

    public long getInstallBeginTimestampSeconds() {
        return installBeginTimestampSeconds;
    }

    public long getReferrerClickTimestampSeconds() {
        return referrerClickTimestampSeconds;
    }

    public long getInstallBeginTimestampServerSeconds() {
        return installBeginTimestampServerSeconds;
    }

    public long getReferrerClickTimestampServerSeconds() {
        return referrerClickTimestampServerSeconds;
    }

    public long getInstallBeginTimestampMillisecond() {
        return installBeginTimestampMillisecond;
    }

    public long getReferrerClickTimestampMillisecond() {
        return referrerClickTimestampMillisecond;
    }
}
