package cn.thinkingdata.installReferrer.manager;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;

import java.lang.reflect.Method;

import cn.thinkingdata.core.utils.TDLog;
import cn.thinkingdata.installReferrer.model.ReferrerInfo;
import cn.thinkingdata.installReferrer.utils.LogUtils;

public class InstallReferrerManager {
    private static final String TAG = LogUtils.INSTALL_REFERRER_TAG + InstallReferrerManager.class.getSimpleName();
    private static String fbAppId;
    private static String fbKey;

    public static ReferrerInfo getInfo(Context context) {

        ReferrerInfo referrerInfo;

        referrerInfo = getMetaInfo(context);
        if (referrerInfo != null) {
            return referrerInfo;
        }
        referrerInfo = getGoogleInfo(context);
        if (referrerInfo != null) {
            return referrerInfo;
        }

        referrerInfo = getHuaweiInfo(context);
        if (referrerInfo != null) {
            return referrerInfo;
        }

        referrerInfo = getSamsungInfo(context);
        if (referrerInfo != null) {
            return referrerInfo;
        }

        referrerInfo = getXiaomiInfo(context);
        return referrerInfo;
    }

    public static Object invokeMethod(Class classObject, String methodName, Object instance, Class[] cArgs, Object... args)
            throws Exception {
        @SuppressWarnings("unchecked")
        Method methodObject = classObject.getMethod(methodName, cArgs);
        if (methodObject == null) {
            return null;
        }

        Object resultObject = methodObject.invoke(instance, args);
        return resultObject;
    }

    private static ReferrerInfo getReflectInfo(Context context, String cls, String methodName) {
        ReferrerInfo referrerInfo = null;
        try {
            Class classObject = Class.forName(cls);
            // 使用无参构造函数创建实例
            Object instance = classObject.getDeclaredConstructor().newInstance();
            referrerInfo = (ReferrerInfo) invokeMethod(classObject, methodName, instance,
                    new Class[]{Context.class},
                    context);
        } catch (Exception e) {
            if (e instanceof java.lang.reflect.InvocationTargetException) {
                java.lang.reflect.InvocationTargetException ite = (java.lang.reflect.InvocationTargetException) e;
                Throwable cause = ite.getCause();
                if (cause != null) {
                    LogUtils.e(TAG, cause.toString());
                }
            }
        }
        return referrerInfo;
    }

    private static ReferrerInfo getGoogleInfo(Context context) {
        return getReflectInfo(context, "cn.thinkingdata.google.GooglePlatform",
                "getReferrerInfo");

    }

    private static ReferrerInfo getHuaweiInfo(Context context) {
        return getReflectInfo(context, "cn.thinkingdata.huawei.HuaweiPlatform",
                "getReferrerInfo");
    }

    private static ReferrerInfo getSamsungInfo(Context context) {
        return getReflectInfo(context, "cn.thinkingdata.samsung.SamsungPlatform",
                "getReferrerInfo");
    }

    private static ReferrerInfo getXiaomiInfo(Context context) {
        return getReflectInfo(context, "cn.thinkingdata.xiaomi.XiaomiPlatform",
                "getReferrerInfo");
    }

    private static ReferrerInfo getMetaInfo(Context context) {
        try {
            getFbInfo(context);
            if (TextUtils.isEmpty(fbAppId) || TextUtils.isEmpty(fbKey)) {
                return null;
            }
            ReferrerInfo referrerInfo = null;
            try {
                Class classObject = Class.forName("cn.thinkingdata.meta.MetaPlatform");
                // 使用无参构造函数创建实例
                Object instance = classObject.getDeclaredConstructor().newInstance();
                referrerInfo = (ReferrerInfo) invokeMethod(
                        classObject, "getReferrerInfo", instance,
                        new Class[]{Context.class, String.class, String.class},
                        context, fbAppId, fbKey);
            } catch (Exception ignore) {
            }
            return referrerInfo;
        } catch (Throwable e) {
            TDLog.e(TAG, "Meta Referrer get failed, throw " + e.getMessage());
        }
        return null;
    }

    private static void getFbInfo(Context context) {
        try {
            // 获取 PackageManager 实例
            PackageManager packageManager = context.getPackageManager();
            // 获取当前应用的 ApplicationInfo
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            // 获取 meta-data
            Bundle metaData = applicationInfo.metaData;

            if (metaData != null) {
                // 读取字符串类型的 meta-data
                fbAppId = metaData.getString("com.facebook.sdk.ApplicationId");
                // 读取整数类型的 meta-data
                fbKey = metaData.getString("com.facebook.sdk.referrer.Key");
            }
        } catch (PackageManager.NameNotFoundException ignore) {
        }
    }
}
