/*
 * Copyright (C) 2022 ThinkingData
 */
package cn.thinkingdata.core.router;

import android.content.Context;
import android.text.TextUtils;

import org.json.JSONObject;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import cn.thinkingdata.core.utils.TDLog;

/**
 *
 * @author liulongbing
 * @since 2022/8/15
 */
public class LogisticsCenter {

    public static Map<String, RouteMeta> routes;
    public static Map<String, RouteMeta> plugins = new HashMap<>();

    public synchronized static void init() {
        routes = TRouterMap.getDefaultRouters();
    }

    public static boolean completion(Postcard postcard) {
        RouteMeta routeMeta;
        routeMeta = plugins.get(postcard.getPath());
        if (null == routeMeta) {
            routeMeta = routes.get(postcard.getPath());
        }
        if (null == routeMeta) {
            return false;
        }
        postcard.setType(routeMeta.getType());
        postcard.setClassName(routeMeta.getClassName());
        postcard.setNeedCache(routeMeta.isNeedCache());
        return true;
    }

    public interface OnLoadPluginCallBack {
        void onPluginLoadSuccess(Set<String> classNames);
    }

}
