/*
 * Copyright (C) 2022 ThinkingData
 */
package cn.thinkingdata.core.router;
import android.content.Context;
/**
 *
 * @author liulongbing
 * @since 2022/8/15
 */
public final class TRouter {

    private volatile static TRouter instance = null;
    private volatile static boolean hasInit = false;

    private TRouter() {

    }

    public static void init() {
        if (!hasInit) {
            hasInit = _TRouter.init();
        }
    }

    public static TRouter getInstance() {
        if (!hasInit) {
            throw new InitException("TRouter::Init::Invoke init(context) first!");
        } else {
            if (instance == null) {
                synchronized (TRouter.class) {
                    if (instance == null) {
                        instance = new TRouter();
                    }
                }
            }
            return instance;
        }
    }

    public Postcard build(String path) {
        return _TRouter.getInstance().build(path);
    }


    public Object navigation(Context mContext, Postcard postcard) {
        return _TRouter.getInstance().navigation(mContext, postcard);
    }

}
