/*
 * Copyright (C) 2022 ThinkingData
 */
package cn.thinkingdata.core.sp;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.concurrent.Future;

/**
 * @author liulongbing
 * @since 2022/9/7
 */
public abstract class AbstractStoragePlugin implements StoragePlugin {

    protected SharedPreferencesLoader sPrefsLoader = new SharedPreferencesLoader();
    protected Future<SharedPreferences> storedSharedPrefs;

    public AbstractStoragePlugin(Context context, String name) {
        storedSharedPrefs = sPrefsLoader.loadPreferences(context, name);
        createStorage(context);
    }

    protected abstract void createStorage(Context context);

    protected abstract <T> SharedPreferencesStorage<T> getSharePreferenceStorage(int type);

    @Override
    public <T> void save(int type, T t) {
        SharedPreferencesStorage<T> sp = getSharePreferenceStorage(type);
        if (null != sp) {
            sp.put(t);
        }
    }

    @Override
    public <T> T get(int type) {
        SharedPreferencesStorage<T> sp = getSharePreferenceStorage(type);
        if (null != sp) {
            return sp.get();
        }
        return null;
    }

}
