package cn.thinkingdata.core.network;

import android.os.Handler;
import android.os.Looper;

public abstract class TEHttpCallback {

    static Handler sMainHandler = new Handler(Looper.getMainLooper());

    public boolean callBackOnMainThread = false;

    void onError(final String msg) {
        if (callBackOnMainThread) {
            sMainHandler.post(new Runnable() {
                @Override
                public void run() {
                    onFailure(msg);
                }
            });
        } else {
            onFailure(msg);
        }
    }

    void onResponse(final String data) {
        if (callBackOnMainThread) {
            sMainHandler.post(new Runnable() {
                @Override
                public void run() {
                    onSuccess(data);
                }
            });
        } else {
            onSuccess(data);
        }
    }

    public abstract void onFailure(String errorMsg);

    public abstract void onSuccess(String data);

}
