/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.therouter.plugin.AddCodeVisitor;
import com.therouter.plugin.LogUI;
import com.therouter.plugin.RouteItem;
import com.therouter.plugin.TheRouterExtension;
import com.therouter.plugin.TheRouterInjects;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public abstract class TheRouterTask
extends DefaultTask {
    private TheRouterExtension theRouterExtension;

    @InputFiles
    public abstract ListProperty<RegularFile> getAllJars();

    @InputFiles
    public abstract ListProperty<Directory> getAllDirectories();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    public void setTheRouterExtension(TheRouterExtension theRouterExtension) {
        this.theRouterExtension = theRouterExtension;
    }

    @TaskAction
    public void taskAction() throws ClassNotFoundException, IOException {
        System.out.println("----------------------TheRouter build start------------------------------");
        this.theRouterTransform();
        System.out.println("----------------------TheRouter build finish-----------------------------");
    }

    private void theRouterTransform() throws ClassNotFoundException, IOException {
        File theRouterJar = null;
        ZipEntry theRouterServiceProvideInjecter = null;
        JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(((RegularFile)this.getOutputFile().get()).getAsFile())));
        HashSet<String> addedEntries = new HashSet<String>();
        for (RegularFile file : (List)this.getAllJars().get()) {
            File jar = file.getAsFile();
            JarFile jarFile = new JarFile(jar);
            Iterator e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                String name = jarEntry.getName();
                if (name.contains("META-INF/") || !addedEntries.add(name)) continue;
                TheRouterInjects.allClass.add(name);
                if (name.contains("TheRouterServiceProvideInjecter")) {
                    theRouterJar = jar;
                    theRouterServiceProvideInjecter = jarEntry;
                    continue;
                }
                if (!name.contains("$")) {
                    ClassNode cn;
                    ClassReader reader;
                    if (name.contains("RouterMap__TheRouter__")) {
                        TheRouterInjects.routeSet.add(name.replaceAll(".class", ""));
                        reader = new ClassReader(jarFile.getInputStream(jarEntry));
                        cn = new ClassNode();
                        reader.accept((ClassVisitor)cn, 0);
                        HashMap<String, String> fieldMap = new HashMap<String, String>();
                        int count = 0;
                        List fieldList = cn.fields;
                        for (FieldNode fieldNode : fieldList) {
                            if ("COUNT".equals(fieldNode.name)) {
                                count = Integer.parseInt(fieldNode.value.toString());
                            }
                            if (!fieldNode.name.startsWith("ROUTERMAP")) continue;
                            fieldMap.put(fieldNode.name, fieldNode.value.toString());
                        }
                        if (fieldMap.size() == 1 && count == 0) {
                            TheRouterInjects.routeMapStringSet.addAll(fieldMap.values());
                        } else if (fieldMap.size() == count) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 0; i < count; ++i) {
                                stringBuilder.append((String)fieldMap.get("ROUTERMAP" + i));
                            }
                            TheRouterInjects.routeMapStringSet.add(stringBuilder.toString());
                        }
                    } else if (name.contains("ServiceProvider__TheRouter__")) {
                        TheRouterInjects.serviceProvideMap.put(name.replaceAll(".class", ""), "1.2.4-rc11");
                        if (!this.theRouterExtension.checkFlowDepend.isEmpty()) {
                            reader = new ClassReader(jarFile.getInputStream(jarEntry));
                            cn = new ClassNode();
                            reader.accept((ClassVisitor)cn, 0);
                            List fieldList = cn.fields;
                            for (FieldNode fieldNode : fieldList) {
                                if (!"FLOW_TASK_JSON".equals(fieldNode.name)) continue;
                                Map map = (Map)TheRouterInjects.gson.fromJson(fieldNode.value.toString(), HashMap.class);
                                TheRouterInjects.flowTaskMap.putAll(map);
                            }
                        }
                    } else if (name.contains("__TheRouter__Autowired")) {
                        TheRouterInjects.autowiredSet.add(name.replaceAll(".class", ""));
                    }
                }
                try {
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    try {
                        int bytesRead;
                        jarOutput.putNextEntry(new JarEntry(name));
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            jarOutput.write(buffer, 0, bytesRead);
                        }
                        jarOutput.closeEntry();
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            jarFile.close();
        }
        for (Directory directory : (List)this.getAllDirectories().get()) {
            for (File file : directory.getAsFileTree()) {
                String name = directory.getAsFile().toURI().relativize(file.toURI()).getPath().replace(File.separatorChar, '/');
                if (name.contains("META-INF/") || !addedEntries.add(name)) continue;
                TheRouterInjects.allClass.add(name);
                if (!name.contains("$")) {
                    ClassNode cn;
                    ClassReader reader;
                    if (name.contains("RouterMap__TheRouter__")) {
                        TheRouterInjects.routeSet.add(name.replaceAll(".class", ""));
                        try {
                            reader = new ClassReader((InputStream)new FileInputStream(file));
                            cn = new ClassNode();
                            reader.accept((ClassVisitor)cn, 0);
                            HashMap<String, String> fieldMap = new HashMap<String, String>();
                            int count = 0;
                            List fieldList = cn.fields;
                            for (FieldNode fieldNode : fieldList) {
                                if ("COUNT".equals(fieldNode.name)) {
                                    count = Integer.parseInt(fieldNode.value.toString());
                                }
                                if (!fieldNode.name.startsWith("ROUTERMAP")) continue;
                                fieldMap.put(fieldNode.name, fieldNode.value.toString());
                            }
                            if (fieldMap.size() == 1 && count == 0) {
                                TheRouterInjects.routeMapStringSet.addAll(fieldMap.values());
                            } else if (fieldMap.size() == count) {
                                StringBuilder stringBuilder = new StringBuilder();
                                for (int i = 0; i < count; ++i) {
                                    stringBuilder.append((String)fieldMap.get("ROUTERMAP" + i));
                                }
                                TheRouterInjects.routeMapStringSet.add(stringBuilder.toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (name.contains("ServiceProvider__TheRouter__")) {
                        TheRouterInjects.serviceProvideMap.put(name.replaceAll(".class", ""), "1.2.4-rc11");
                        try {
                            reader = new ClassReader((InputStream)new FileInputStream(file));
                            cn = new ClassNode();
                            reader.accept((ClassVisitor)cn, 0);
                            List fieldList = cn.fields;
                            for (FieldNode fieldNode : fieldList) {
                                if (!"FLOW_TASK_JSON".equals(fieldNode.name)) continue;
                                Map map = (Map)TheRouterInjects.gson.fromJson(fieldNode.value.toString(), HashMap.class);
                                TheRouterInjects.flowTaskMap.putAll(map);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (name.contains("__TheRouter__Autowired")) {
                        TheRouterInjects.autowiredSet.add(name.replaceAll(".class", ""));
                    }
                }
                try (FileInputStream inputStream = new FileInputStream(file);){
                    int bytesRead;
                    jarOutput.putNextEntry(new JarEntry(name));
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        jarOutput.write(buffer, 0, bytesRead);
                    }
                    jarOutput.closeEntry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (theRouterJar != null && theRouterServiceProvideInjecter != null) {
            JarFile jarFile = new JarFile(theRouterJar);
            jarOutput.putNextEntry(new JarEntry(theRouterServiceProvideInjecter.getName()));
            ClassReader cr = new ClassReader(jarFile.getInputStream(theRouterServiceProvideInjecter));
            ClassWriter cw = new ClassWriter(2);
            AddCodeVisitor cv = new AddCodeVisitor((ClassVisitor)cw, TheRouterInjects.serviceProvideMap, TheRouterInjects.autowiredSet, TheRouterInjects.routeSet, false);
            cr.accept((ClassVisitor)cv, 2);
            byte[] bytes = cw.toByteArray();
            jarOutput.write(bytes);
            jarOutput.closeEntry();
            jarFile.close();
        }
        jarOutput.close();
        HashSet<RouteItem> pageSet = new HashSet<RouteItem>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String routeMapString : TheRouterInjects.routeMapStringSet) {
            pageSet.addAll((Collection)gson.fromJson(routeMapString, new TypeToken<List<RouteItem>>(){}.getType()));
        }
        File assetRouteMap = new File(this.getProject().getProjectDir(), "src/main/assets/therouter/routeMap.json");
        if (assetRouteMap.exists()) {
            if ("delete".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                System.out.println("---------TheRouter delete route map------------------------------------------");
                assetRouteMap.delete();
                try {
                    assetRouteMap.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String assetString = null;
                try {
                    assetString = ResourceGroovyMethods.getText((File)assetRouteMap, (String)StandardCharsets.UTF_8.displayName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("---------TheRouter get route map from: /assets/therouter/routeMap.json-------");
                try {
                    ArrayList assetsList = (ArrayList)gson.fromJson(assetString, new TypeToken<List<RouteItem>>(){}.getType());
                    if (assetsList == null) {
                        assetsList = new ArrayList();
                    }
                    for (RouteItem item : assetsList) {
                        if (pageSet.contains(item)) continue;
                        pageSet.add(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("---------TheRouter route map does not exist: /assets/therouter/routeMap.json-------");
            try {
                assetRouteMap.getParentFile().mkdirs();
                assetRouteMap.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<RouteItem>> result = new HashMap<String, ArrayList<RouteItem>>();
        for (RouteItem routeItem : pageSet) {
            ArrayList<RouteItem> routeList;
            String url = routeItem.path;
            if (url.contains("?")) {
                try {
                    URI uri = new URI(routeItem.path);
                    Map<String, String> map = TheRouterTask.extractQueryParams(uri);
                    routeItem.params.putAll(map);
                    url = url.substring(0, url.indexOf(63));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if ((routeList = (ArrayList<RouteItem>)result.get(url)) == null) {
                routeList = new ArrayList<RouteItem>();
                result.put(url, routeList);
            }
            routeList.add(routeItem);
        }
        for (List routeItems : result.values()) {
            String className = null;
            for (RouteItem routeItem : routeItems) {
                if (className == null) {
                    className = routeItem.className;
                } else if (!className.equals(routeItem.className)) {
                    throw new RuntimeException("Multiple Activity to single Url: " + className + " and " + routeItem.className);
                }
                if (!TheRouterPluginUtils.needCheckRouteItemClass(this.theRouterExtension.checkRouteMap)) continue;
                boolean classNotFound = true;
                for (String item : TheRouterInjects.allClass) {
                    if (!item.contains(routeItem.className.replace(".", "/"))) continue;
                    classNotFound = false;
                    break;
                }
                if (!classNotFound) continue;
                if ("error".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                    throw new ClassNotFoundException(routeItem.className + " in /assets/therouter/routeMap.json");
                }
                if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) continue;
                System.out.println(LogUI.C_WARN.getValue() + "[" + routeItem.className + " in /assets/therouter/routeMap.json]" + LogUI.E_NORMAL.getValue());
            }
        }
        ArrayList pageList = new ArrayList(pageSet);
        Collections.sort(pageList);
        String json = gson.toJson(pageList);
        ResourceGroovyMethods.write((File)assetRouteMap, (String)json, (String)StandardCharsets.UTF_8.displayName());
        System.out.println("---------TheRouter create new route map--------------");
        HashMap<String, Set<String>> flowTaskDependMap = new HashMap<String, Set<String>>();
        for (String key : TheRouterInjects.flowTaskMap.keySet()) {
            String dependsOn;
            HashSet<String> value = (HashSet<String>)flowTaskDependMap.get(key);
            if (value == null) {
                value = new HashSet<String>();
            }
            if ((dependsOn = TheRouterInjects.flowTaskMap.get(key)) != null && !dependsOn.isBlank()) {
                String[] dependencies;
                for (String depend : dependencies = dependsOn.split(",")) {
                    if (depend.isBlank()) continue;
                    value.add(depend.trim());
                }
            }
            flowTaskDependMap.put(key, value);
        }
        if (!this.theRouterExtension.checkFlowDepend.isEmpty()) {
            for (String taskName : flowTaskDependMap.keySet()) {
                Set dependencies = (Set)flowTaskDependMap.get(taskName);
                for (String dependency : dependencies) {
                    if (flowTaskDependMap.containsKey(dependency)) continue;
                    if ("error".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) {
                        throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::\nCan not found Task: [" + dependency + "] from " + taskName + " dependsOn\n==========================================\n\n");
                    }
                    if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) continue;
                    System.out.println();
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::   " + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "Can not found Task: [" + dependency + "] from " + taskName + " dependsOn" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println();
                }
            }
        }
        for (String key : flowTaskDependMap.keySet()) {
            TheRouterPluginUtils.fillTodoList(flowTaskDependMap, key);
        }
        if (this.theRouterExtension.showFlowDepend) {
            for (String key : flowTaskDependMap.keySet()) {
                TheRouterPluginUtils.fillNode(TheRouterPluginUtils.createNode(flowTaskDependMap, key), null);
            }
            System.out.println();
            System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::dependency   " + LogUI.E_NORMAL.getValue());
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            ArrayList<String> dependStack = new ArrayList<String>(TheRouterPluginUtils.dependStack);
            Collections.sort(dependStack);
            for (String it : dependStack) {
                System.out.println(LogUI.C_WARN.getValue() + "[Root --> " + it + "]" + LogUI.E_NORMAL.getValue());
            }
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            System.out.println();
        }
        System.out.println("---------TheRouter check flow task map--------------");
    }

    private static Map<String, String> extractQueryParams(URI uri) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return queryPairs;
    }
}

