/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.therouter.plugin.AddCodeVisitor;
import com.therouter.plugin.agp8.TextParameters;
import com.therouter.plugin.agp8.TheRouterFieldVisitor;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.objectweb.asm.ClassVisitor;

public abstract class TheRouterASM
implements AsmClassVisitorFactory<TextParameters> {
    public static final String INJECTER_FULL_CLASSNAME = "a.TheRouterServiceProvideInjecter";

    public ClassVisitor createClassVisitor(ClassContext classContext, ClassVisitor classVisitor) {
        String currentClassName = classContext.getCurrentClassData().getClassName();
        if (INJECTER_FULL_CLASSNAME.equals(currentClassName)) {
            File asmTargetFile = (File)((TextParameters)this.getParameters().get()).getAsmTargetFile().get();
            HashMap<String, String> serviceProvideMap = new HashMap<String, String>();
            HashSet<String> autowiredSet = new HashSet<String>();
            HashSet<String> routeSet = new HashSet<String>();
            for (String name : TheRouterPluginUtils.getSetFromFile(asmTargetFile)) {
                if (name.contains("RouterMap__TheRouter__")) {
                    routeSet.add(name.trim());
                    continue;
                }
                if (name.contains("ServiceProvider__TheRouter__")) {
                    serviceProvideMap.put(name.trim().substring(2), "1.2.3-rc15");
                    continue;
                }
                if (!name.contains("__TheRouter__Autowired")) continue;
                autowiredSet.add(name.trim());
            }
            return new AddCodeVisitor(classVisitor, serviceProvideMap, autowiredSet, routeSet, false);
        }
        if (currentClassName.contains("RouterMap__TheRouter__")) {
            return new TheRouterFieldVisitor(classVisitor, (File)((TextParameters)this.getParameters().get()).getRouteFile().get());
        }
        if (currentClassName.contains("ServiceProvider__TheRouter__")) {
            return new TheRouterFieldVisitor(classVisitor, (File)((TextParameters)this.getParameters().get()).getFlowTaskFile().get());
        }
        return null;
    }

    public boolean isInstrumentable(ClassData classData) {
        String className = classData.getClassName().replaceAll("\\.", "/");
        String allClassText = (String)((TextParameters)this.getParameters().get()).getAllClassText().get();
        boolean isDebug = (Boolean)((TextParameters)this.getParameters().get()).getDebugValue().get();
        String checkRouteMap = (String)((TextParameters)this.getParameters().get()).getCheckRouteMapValue().get();
        if (!allClassText.contains(className) && TheRouterPluginUtils.needTagClass(checkRouteMap)) {
            File allClassFile = (File)((TextParameters)this.getParameters().get()).getAllClassFile().get();
            TheRouterPluginUtils.addTextToFile(allClassFile, className, isDebug);
        }
        if (className.contains("$")) {
            return false;
        }
        String asmTargetText = (String)((TextParameters)this.getParameters().get()).getAsmTargetText().get();
        if (className.contains("RouterMap__TheRouter__")) {
            if (!asmTargetText.contains(className)) {
                File asmTargetFile = (File)((TextParameters)this.getParameters().get()).getAsmTargetFile().get();
                TheRouterPluginUtils.addTextToFile(asmTargetFile, className, isDebug);
            }
            return TheRouterPluginUtils.needTagClass(checkRouteMap);
        }
        if (className.contains("ServiceProvider__TheRouter__")) {
            String checkflowDepend;
            if (!asmTargetText.contains(className)) {
                File asmTargetFile = (File)((TextParameters)this.getParameters().get()).getAsmTargetFile().get();
                TheRouterPluginUtils.addTextToFile(asmTargetFile, className, isDebug);
            }
            return !(checkflowDepend = (String)((TextParameters)this.getParameters().get()).getCheckFlowDependValue().get()).isEmpty();
        }
        if (className.contains("__TheRouter__Autowired")) {
            if (!asmTargetText.contains(className)) {
                File asmTargetFile = (File)((TextParameters)this.getParameters().get()).getAsmTargetFile().get();
                TheRouterPluginUtils.addTextToFile(asmTargetFile, className, isDebug);
            }
            return false;
        }
        return INJECTER_FULL_CLASSNAME.equals(classData.getClassName());
    }
}

