package com.therouter.plugin

import com.android.build.gradle.AppExtension
import org.gradle.api.Plugin
import org.gradle.api.Project

public class TheRouterPlugin implements Plugin<Project> {
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final String DELETE = "delete";

    @Override
    void apply(Project project) {
        project.extensions.create('TheRouter', TheRouterExtension)
        TheRouterExtension theRouterExtension = new TheRouterExtension();
        if (project.TheRouter) {
            theRouterExtension.sourceOnly = Boolean.valueOf(project.TheRouter.sourceOnly)
            theRouterExtension.debug = Boolean.valueOf(project.TheRouter.debug)
            theRouterExtension.checkRouteMap = project.TheRouter.checkRouteMap
            theRouterExtension.checkFlowDepend = project.TheRouter.checkFlowDepend
            theRouterExtension.showFlowDepend = project.TheRouter.showFlowDepend
            theRouterExtension.scan = project.TheRouter.scan
            theRouterExtension.ignore = project.TheRouter.ignore
        }

        boolean isLibrary = project.getPlugins().hasPlugin("com.android.library")
        if (!isLibrary) {
            def android = project.extensions.getByType(AppExtension)
            def therouterTransform = new TheRouterTransform(project, theRouterExtension)
            android.registerTransform(therouterTransform)
        } else {
            throw new RuntimeException("`apply plugin: 'therouter'` must call in app module! You need remove at ${project.name} module.")
        }
    }
}