package com.therouter.plugin.utils;

import com.therouter.plugin.Node;
import com.therouter.plugin.TheRouterPlugin;

import org.gradle.api.Project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TheRouterPluginUtils {
    private static final Map<String, String> buildProperties = new HashMap<>();

    public static String getLog(List<String> list, String root) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String task : list) {
            stringBuilder.append(task).append("-->");
        }
        if (root != null) {
            stringBuilder.append(root);
        }
        return stringBuilder.toString();
    }

    public static String getLocalProperty(Project project, String key) {
        try {
            if (!buildProperties.containsKey(key)) {
                initProperties(project);
            }
            String value = buildProperties.get(key);
            return value == null ? "" : value;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void initProperties(Project mProject) {
        File gradlePropertiesFile;
        try {
            gradlePropertiesFile = new File(mProject.getRootDir(), "gradle.properties");
            if (!gradlePropertiesFile.exists()) {
                gradlePropertiesFile = new File("../gradle.properties");
            }
        } catch (Exception e) {
            gradlePropertiesFile = new File("../gradle.properties");
        }
        Properties gradleProperties = new Properties();
        try {
            gradleProperties.load(new FileInputStream(gradlePropertiesFile));
        } catch (Exception e) {
            e.printStackTrace();
        }
        buildProperties.put(TheRouterPlugin.CHECK_ROUTE_MAP, gradleProperties.getProperty(TheRouterPlugin.CHECK_ROUTE_MAP));
        buildProperties.put(TheRouterPlugin.CHECK_FLOW_UNKNOW_DEPEND, gradleProperties.getProperty(TheRouterPlugin.CHECK_FLOW_UNKNOW_DEPEND));
        buildProperties.put(TheRouterPlugin.SHOW_FLOW_DEPEND, gradleProperties.getProperty(TheRouterPlugin.SHOW_FLOW_DEPEND));
        buildProperties.put(TheRouterPlugin.INCREMENTAL, gradleProperties.getProperty(TheRouterPlugin.INCREMENTAL));

        File localPropertiesFile;
        try {
            localPropertiesFile = new File(mProject.getRootDir(), "local.properties");
            if (!localPropertiesFile.exists()) {
                localPropertiesFile = new File("../local.properties");
            }
        } catch (Exception e) {
            localPropertiesFile = new File("../local.properties");
        }
        Properties localProperties = new Properties();
        try {
            localProperties.load(new FileInputStream(localPropertiesFile));
        } catch (Exception e) {
            e.printStackTrace();
        }
        String v = localProperties.getProperty(TheRouterPlugin.CHECK_ROUTE_MAP);
        if (v != null && !v.isEmpty()) {
            buildProperties.put(TheRouterPlugin.CHECK_ROUTE_MAP, v);
        }
        v = localProperties.getProperty(TheRouterPlugin.CHECK_FLOW_UNKNOW_DEPEND);
        if (v != null && !v.isEmpty()) {
            buildProperties.put(TheRouterPlugin.CHECK_FLOW_UNKNOW_DEPEND, v);
        }
        v = localProperties.getProperty(TheRouterPlugin.SHOW_FLOW_DEPEND);
        if (v != null && !v.isEmpty()) {
            buildProperties.put(TheRouterPlugin.SHOW_FLOW_DEPEND, v);
        }
        v = localProperties.getProperty(TheRouterPlugin.INCREMENTAL);
        if (v != null && !v.isEmpty()) {
            buildProperties.put(TheRouterPlugin.INCREMENTAL, v);
        }
    }

    public static String set2String(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String item : set) {
            stringBuilder.append(item.trim()).append("\n");
        }
        return stringBuilder.toString();
    }

    public static File createCacheFile(Project project, String name) {
        File folder = new File(project.getBuildDir().getAbsolutePath() + "/generated/therouter");
        folder.mkdirs();
        File cache = new File(folder, name);
        if (!cache.exists()) {
            try {
                cache.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cache;
    }

    private static final List<String> loopDependStack = new ArrayList<>();

    public static void fillTodoList(Map<String, Set<String>> map, String root) {
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            if (loopDependStack.contains(root)) {
                throw new RuntimeException("\n\n==========================================" +
                        "\nTheRouter:: FlowTask::   " +
                        "\nCyclic dependency: [" + getLog(loopDependStack, root) + "]" +
                        "\n==========================================\n\n");
            }
            loopDependStack.add(root);
            for (String depend : dependsSet) {
                fillTodoList(map, depend);
            }
            loopDependStack.remove(root);
        }
    }

    public static Set<String> dependStack = new HashSet<>();

    public static void fillNode(Node node, String root) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            if (root == null) {
                dependStack.add(node.getName());
            } else {
                dependStack.add(node.getName() + " --> " + root);
            }
        } else {
            for (Node it : node.getChildren()) {
                if (root == null) {
                    fillNode(it, node.getName());
                } else {
                    fillNode(it, node.getName() + " --> " + root);
                }
            }
        }
    }

    public static Node createNode(Map<String, Set<String>> map, String root) {
        final Node node = new Node(root);
        Set<Node> childrenNode = new HashSet<>();
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            for (String depend : dependsSet) {
                childrenNode.add(createNode(map, depend));
            }
        }
        node.setChildren(childrenNode);
        return node;
    }
}
