/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin;

import com.therouter.plugin.Node;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.Project;

public class Utils {
    private static final Map<String, String> buildProperties = new HashMap<String, String>();
    private static final List<String> loopDependStack = new ArrayList<String>();
    public static Set<String> dependStack = new HashSet<String>();

    public static String getLog(List<String> list, String root) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String task : list) {
            stringBuilder.append(task).append("-->");
        }
        if (root != null) {
            stringBuilder.append(root);
        }
        return stringBuilder.toString();
    }

    public static String getLocalProperty(Project project, String key) {
        try {
            String value;
            if (!buildProperties.containsKey(key)) {
                Utils.initProperties(project);
            }
            return (value = buildProperties.get(key)) == null ? "" : value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void initProperties(Project mProject) {
        File localPropertiesFile;
        File gradlePropertiesFile;
        try {
            gradlePropertiesFile = new File(mProject.getRootDir(), "gradle.properties");
            if (!gradlePropertiesFile.exists()) {
                gradlePropertiesFile = new File("../gradle.properties");
            }
        }
        catch (Exception e) {
            gradlePropertiesFile = new File("../gradle.properties");
        }
        Properties gradleProperties = new Properties();
        try {
            gradleProperties.load(new FileInputStream(gradlePropertiesFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buildProperties.put("CHECK_ROUTE_MAP", gradleProperties.getProperty("CHECK_ROUTE_MAP"));
        buildProperties.put("CHECK_FLOW_UNKNOW_DEPEND", gradleProperties.getProperty("CHECK_FLOW_UNKNOW_DEPEND"));
        buildProperties.put("SHOW_FLOW_DEPEND", gradleProperties.getProperty("SHOW_FLOW_DEPEND"));
        buildProperties.put("THEROUTER_OPEN_INCREMENTAL", gradleProperties.getProperty("THEROUTER_OPEN_INCREMENTAL"));
        try {
            localPropertiesFile = new File(mProject.getRootDir(), "local.properties");
            if (!localPropertiesFile.exists()) {
                localPropertiesFile = new File("../local.properties");
            }
        }
        catch (Exception e) {
            localPropertiesFile = new File("../local.properties");
        }
        Properties localProperties = new Properties();
        try {
            localProperties.load(new FileInputStream(localPropertiesFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String v = localProperties.getProperty("CHECK_ROUTE_MAP");
        if (v != null && !v.isEmpty()) {
            buildProperties.put("CHECK_ROUTE_MAP", v);
        }
        if ((v = localProperties.getProperty("CHECK_FLOW_UNKNOW_DEPEND")) != null && !v.isEmpty()) {
            buildProperties.put("CHECK_FLOW_UNKNOW_DEPEND", v);
        }
        if ((v = localProperties.getProperty("SHOW_FLOW_DEPEND")) != null && !v.isEmpty()) {
            buildProperties.put("SHOW_FLOW_DEPEND", v);
        }
        if ((v = localProperties.getProperty("THEROUTER_OPEN_INCREMENTAL")) != null && !v.isEmpty()) {
            buildProperties.put("THEROUTER_OPEN_INCREMENTAL", v);
        }
    }

    public static String set2String(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String item : set) {
            stringBuilder.append(item.trim()).append("\n");
        }
        return stringBuilder.toString();
    }

    public static File createCacheFile(Project project, String name) {
        File folder = new File(project.getBuildDir().getAbsolutePath() + "/generated/therouter");
        folder.mkdirs();
        File cache = new File(folder, name);
        if (!cache.exists()) {
            try {
                cache.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cache;
    }

    public static void fillTodoList(Map<String, Set<String>> map, String root) {
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            if (loopDependStack.contains(root)) {
                throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::   \nCyclic dependency: [" + Utils.getLog(loopDependStack, root) + "]\n==========================================\n\n");
            }
            loopDependStack.add(root);
            for (String depend : dependsSet) {
                Utils.fillTodoList(map, depend);
            }
            loopDependStack.remove(root);
        }
    }

    public static void fillNode(Node node, String root) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            if (root == null) {
                dependStack.add(node.getName());
            } else {
                dependStack.add(node.getName() + " --> " + root);
            }
        } else {
            for (Node it : node.getChildren()) {
                if (root == null) {
                    Utils.fillNode(it, node.getName());
                    continue;
                }
                Utils.fillNode(it, node.getName() + " --> " + root);
            }
        }
    }

    public static Node createNode(Map<String, Set<String>> map, String root) {
        Node node = new Node(root);
        HashSet<Node> childrenNode = new HashSet<Node>();
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            for (String depend : dependsSet) {
                childrenNode.add(Utils.createNode(map, depend));
            }
        }
        node.setChildren(childrenNode);
        return node;
    }
}

