package com.therouter.plugin;

import com.google.gson.Gson
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils
import org.gradle.api.Project;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode

import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

/**
 * Created by ZhangTao on 18/2/24.
 */

class TheRouterInjects {

    public static final String THEROUTER_SERVICE_PROVIDER_CLASS = "therouter_service_provider_class";
    public static final String THEROUTER_ROUTEMAP_CLASS = "therouter_routemap_class";
    public static final String THEROUTER_AUTOWIRED_CLASS = "therouter_autowired_class";

    private static final String PREFIX_SERVICE_PROVIDER = "ServiceProvider__TheRouter__";
    private static final String PREFIX_ROUTER_MAP = "RouterMap__TheRouter__";
    private static final String SUFFIX_AUTOWIRED_DOT_CLASS = "__TheRouter__Autowired.class";
    private static final String FIELD_FLOW_TASK_JSON = "FLOW_TASK_JSON";
    private static final String FIELD_APT_VERSION = "THEROUTER_APT_VERSION";
    private static final String FIELD_ROUTER_MAP = "ROUTERMAP";
    private static final String UNKNOWN_VERSION = "unspecified";
    private static final String NOT_FOUND_VERSION = "0.0.0";
    private static final String DOT_CLASS = ".class";

    public static SourceInfo tagClass(Project mProject, File dir) throws Exception {
        SourceInfo sourceInfo = new SourceInfo();
        if (dir.isDirectory()) {
            dir.eachFileRecurse {
                if (it.isFile() && it.name.endsWith(DOT_CLASS)) {
                    sourceInfo.allSourceClass.add(it.getAbsolutePath().replace(File.separator, "."));
                    if (it.getAbsolutePath().contains(PREFIX_SERVICE_PROVIDER)) {
                        int start = it.getAbsolutePath().indexOf(PREFIX_SERVICE_PROVIDER);
                        int end = it.getAbsolutePath().length() - DOT_CLASS.length();
                        String className = it.getAbsolutePath().substring(start, end)
                                .replace(File.separator, ".");
                        if (className.indexOf('$') > 0) {
                            className = className.substring(0, className.indexOf('$'));
                        }
                        FileInputStream inputStream = new FileInputStream(it);
                        ClassReader reader = new ClassReader(inputStream);
                        ClassNode cn = new ClassNode();
                        reader.accept(cn, 0);
                        List<FieldNode> fieldList = cn.fields;
                        for (FieldNode fieldNode : fieldList) {
                            if (FIELD_FLOW_TASK_JSON.equals(fieldNode.name)) {
                                System.out.println("---------TheRouter in source get flow task json from: " + it.getName() + "---------------");
                                sourceInfo.serviceProviderFromSource.add(fieldNode.value.toString());
                            }
                        }
                        // 记录serviceProvider生成类
                        if (!className.isEmpty()) {
                            FileUtils.write(Utils.createCacheFile(mProject, THEROUTER_SERVICE_PROVIDER_CLASS), className, "UTF-8", true);
                        }
                    } else if (it.getAbsolutePath().contains(SUFFIX_AUTOWIRED_DOT_CLASS)) {
                        String className = it.getAbsolutePath()
                                .replace(dir.getAbsolutePath(), "")
                                .replace(DOT_CLASS, "")
                                .replace(File.separator, ".")
                                .replace("classes.", "");
                        if (className.startsWith(".")) {
                            className = className.substring(1);
                        }
                        // 记录autowired生成类
                        if (!className.isEmpty()) {
                            FileUtils.write(Utils.createCacheFile(mProject, THEROUTER_AUTOWIRED_CLASS), className, "UTF-8", true);
                        }
                    } else if (it.getAbsolutePath().contains(PREFIX_ROUTER_MAP)) {
                        int start = it.getAbsolutePath().indexOf(PREFIX_ROUTER_MAP);
                        int end = it.getAbsolutePath().length() - DOT_CLASS.length();
                        String className = it.getAbsolutePath().substring(start, end)
                                .replace(File.separator, ".");

                        // 记录routermap生成类
                        if (!className.isEmpty()) {
                            // 因为absolutePath过滤的时候是直接以类名过滤，就把包名去掉了
                            // 包名一定是a，所以这里补回来
                            FileUtils.write(Utils.createCacheFile(mProject, THEROUTER_ROUTEMAP_CLASS), "a/" + className, "UTF-8", true);
                        }

                        FileInputStream inputStream = new FileInputStream(it);
                        ClassReader reader = new ClassReader(inputStream);
                        ClassNode cn = new ClassNode();
                        reader.accept(cn, 0);
                        List<FieldNode> fieldList = cn.fields;
                        for (FieldNode fieldNode : fieldList) {
                            if (FIELD_ROUTER_MAP.equals(fieldNode.name)) {
                                System.out.println("---------TheRouter in source get route map from: " + it.getName() + "----------------");
                                sourceInfo.routeMapStringFromSource.add(fieldNode.value.toString());
                            }
                        }
                    }
                }
            }
        }
        return sourceInfo;
    }

    /**
     * 开始修改 TheRouterServiceProvideInjecter 类
     */
    static void injectClassCode(File inputJarFile, Map<String, String> serviceProvideMap, Set<String> autowiredSet,
                                Set<String> routeSet, boolean isIncremental) throws Exception {
        long start = System.currentTimeMillis();
        File optJarFile = new File(inputJarFile.getParent(), inputJarFile.getName() + ".opt");
        JarFile inputJar = new JarFile(inputJarFile);
        Enumeration enumeration = inputJar.entries();
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(optJarFile));
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = (JarEntry) enumeration.nextElement();
            String entryName = jarEntry.getName();
            ZipEntry zipEntry = new ZipEntry(entryName);
            jarOutputStream.putNextEntry(zipEntry);
            InputStream inputStream = inputJar.getInputStream(jarEntry);
            byte[] bytes;
            if (entryName.contains("TheRouterServiceProvideInjecter")) {
                ClassReader cr = new ClassReader(inputStream);
                ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_FRAMES);
                AddCodeVisitor cv = new AddCodeVisitor(cw, serviceProvideMap, autowiredSet, routeSet, isIncremental);
                cr.accept(cv, ClassReader.SKIP_DEBUG);
                bytes = cw.toByteArray();
            } else {
                bytes = IOUtils.toByteArray(inputStream);
            }
            jarOutputStream.write(bytes);
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
        inputJar.close();
        inputJarFile.delete();
        optJarFile.renameTo(inputJarFile);
        optJarFile.delete();
        long time = System.currentTimeMillis() - start;
        System.out.println("---------TheRouter inject TheRouterServiceProvideInjecter.class, spend：" + time + "ms----------------------");
    }
}
