package com.therouter.plugin

import com.android.build.gradle.AppExtension
import com.android.build.gradle.AppPlugin
import org.gradle.api.Plugin
import org.gradle.api.Project

public class TheRouterPlugin implements Plugin<Project> {
    public static final String CHECK_ROUTE_MAP = "CHECK_ROUTE_MAP";
    public static final String CHECK_FLOW_UNKNOW_DEPEND = "CHECK_FLOW_UNKNOW_DEPEND";
    public static final String SHOW_FLOW_DEPEND = "SHOW_FLOW_DEPEND";
    public static final String INCREMENTAL = "THEROUTER_OPEN_INCREMENTAL";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final String DELETE = "delete";

    @Override
    void apply(Project project) {
        project.rootProject.subprojects.each { subProject ->
            boolean hasTheRouterPlugin = false
            boolean isLibrary = false
            println "==1=========" + subProject.name
            subProject.plugins.each { plugin ->
                if (plugin.getClass().name.contains("LibraryPlugin")) {
                    isLibrary = true
                } else if (plugin.getClass().name.contains("therouter")) {
                    hasTheRouterPlugin = true
                }
                println "==2=========" + plugin.class.name
            }
            // 如果lib模块没有加插件
            if (isLibrary && !hasTheRouterPlugin) {
                throw new RuntimeException("since v1.2.3, `apply plugin: 'therouter'` must call in every module")
            }
        }
        boolean isLibrary = false
        project.plugins.each {
            if (it.getClass().name.contains("LibraryPlugin")) {
                isLibrary = true
            }
        }
        def android = project.extensions.getByType(AppExtension)
        def therouterTransform = new TheRouterTransform(project, isLibrary)
        android.registerTransform(therouterTransform)
    }
}