/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.utils;

import com.therouter.plugin.Node;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;

public class TheRouterPluginUtils {
    private static final List<String> loopDependStack = new ArrayList<String>();
    public static Set<String> dependStack = new HashSet<String>();

    public static String getLog(List<String> list, String root) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String task : list) {
            stringBuilder.append(task).append("-->");
        }
        if (root != null) {
            stringBuilder.append(root);
        }
        return stringBuilder.toString();
    }

    public static void fillTodoList(Map<String, Set<String>> map, String root) {
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            if (loopDependStack.contains(root)) {
                throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::   \nCyclic dependency: [" + TheRouterPluginUtils.getLog(loopDependStack, root) + "]\n==========================================\n\n");
            }
            loopDependStack.add(root);
            for (String depend : dependsSet) {
                TheRouterPluginUtils.fillTodoList(map, depend);
            }
            loopDependStack.remove(root);
        }
    }

    public static void fillNode(Node node, String root) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            if (root == null) {
                dependStack.add(node.getName());
            } else {
                dependStack.add(node.getName() + " --> " + root);
            }
        } else {
            for (Node it : node.getChildren()) {
                if (root == null) {
                    TheRouterPluginUtils.fillNode(it, node.getName());
                    continue;
                }
                TheRouterPluginUtils.fillNode(it, node.getName() + " --> " + root);
            }
        }
    }

    public static Node createNode(Map<String, Set<String>> map, String root) {
        Node node = new Node(root);
        HashSet<Node> childrenNode = new HashSet<Node>();
        Set<String> dependsSet = map.get(root);
        if (dependsSet != null && !dependsSet.isEmpty()) {
            for (String depend : dependsSet) {
                childrenNode.add(TheRouterPluginUtils.createNode(map, depend));
            }
        }
        node.setChildren(childrenNode);
        return node;
    }

    public static Set<String> getSetFromFile(File buildCacheFile) {
        HashSet<String> set = new HashSet<String>();
        if (buildCacheFile.exists()) {
            try {
                String[] array;
                for (String item : array = ResourceGroovyMethods.getText((File)buildCacheFile, (String)StandardCharsets.UTF_8.displayName()).split("\n")) {
                    if (item.trim().isBlank()) continue;
                    set.add(item.trim());
                }
            }
            catch (IOException e) {
                System.out.println("Failed to read " + buildCacheFile.getName() + " file.");
                e.printStackTrace();
            }
        }
        return set;
    }

    public static String getTextFromFile(File buildCacheFile) {
        StringBuilder dataStringBuilder = new StringBuilder();
        if (buildCacheFile.exists()) {
            try {
                Set<String> set = TheRouterPluginUtils.getSetFromFile(buildCacheFile);
                ArrayList<String> list = new ArrayList<String>(set);
                Collections.sort(list);
                for (String item : list) {
                    dataStringBuilder.append(item).append("\n");
                }
            }
            catch (Exception e) {
                System.out.println("Failed to parse " + buildCacheFile.getName() + " file.");
                e.printStackTrace();
            }
        }
        return dataStringBuilder.toString();
    }

    public static void addTextToFileIgnoreCheck(File buildCacheFile, String line, boolean debug) {
        if (debug) {
            System.out.println("TheRouter::" + buildCacheFile.getName() + " -> " + line);
        }
        if (!buildCacheFile.exists()) {
            try {
                buildCacheFile.getParentFile().mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                buildCacheFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            ResourceGroovyMethods.append((File)buildCacheFile, (Object)(line + "\n"), (String)StandardCharsets.UTF_8.displayName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addTextToFile(File buildCacheFile, String line, boolean debug) {
        if (!((String)line).contains("$")) {
            if (!(((String)line).endsWith(".class") || ((String)line).contains("\"") || ((String)line).contains("[") || ((String)line).contains("{"))) {
                line = (String)line + ".class";
            }
            TheRouterPluginUtils.addTextToFileIgnoreCheck(buildCacheFile, (String)line, debug);
        }
    }

    public static boolean needCheckRouteItemClass(String mode) {
        return !mode.isEmpty() && !"delete".equals(mode);
    }
}

