/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.therouter.plugin.LogUI;
import com.therouter.plugin.RouteItem;
import com.therouter.plugin.TheRouterExtension;
import com.therouter.plugin.TheRouterInjects;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class TheRouterTask
extends DefaultTask {
    private TheRouterExtension theRouterExtension;
    private String buildDataText;
    private File buildCacheFile;
    private File buildDataFile;

    @InputFiles
    public abstract ListProperty<RegularFile> getAllJars();

    @InputFiles
    public abstract ListProperty<Directory> getAllDirectories();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    public void setTheRouterExtension(TheRouterExtension theRouterExtension) {
        this.theRouterExtension = theRouterExtension;
    }

    public void setBuildDataText(String buildDataText) {
        this.buildDataText = buildDataText;
    }

    public void setBuildCacheFile(File buildCacheFile) {
        this.buildCacheFile = buildCacheFile;
    }

    public void setBuildDataFile(File buildDataFile) {
        this.buildDataFile = buildDataFile;
    }

    @TaskAction
    public void taskAction() throws ClassNotFoundException, IOException {
        System.out.println("TheRouter\u7f16\u8bd1\u63d2\u4ef6\uff1a" + LogUI.C_BLACK_GREEN.getValue() + "cn.therouter:plugin:1.2.3-rc9" + LogUI.E_NORMAL.getValue());
        System.out.println("JDK Version::" + System.getProperty("java.version"));
        System.out.println("Gradle Version::" + this.getProject().getGradle().getGradleVersion());
        System.out.println("checkRouteMap::" + this.theRouterExtension.checkRouteMap);
        System.out.println("checkFlowDepend::" + this.theRouterExtension.checkFlowDepend);
        System.out.println("----------------------TheRouter build start------------------------------");
        this.theRouterTransform();
        this.checkBuildCache();
        System.out.println("----------------------TheRouter build finish-----------------------------");
    }

    private void theRouterTransform() throws ClassNotFoundException, IOException {
        File buildDir = (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get();
        File theRouterCacheFolder = new File(buildDir, "therouter");
        theRouterCacheFolder.mkdirs();
        JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(((RegularFile)this.getOutputFile().get()).getAsFile())));
        for (RegularFile file2 : (List)this.getAllJars().get()) {
            File jar = file2.getAsFile();
            JarFile jarFile = new JarFile(jar);
            Iterator e = jarFile.entries();
            while (e.hasMoreElements()) {
                int bytesRead;
                JarEntry jarEntry = e.nextElement();
                jarOutput.putNextEntry(new JarEntry(jarEntry.getName()));
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    jarOutput.write(buffer, 0, bytesRead);
                }
                jarOutput.closeEntry();
            }
            jarFile.close();
        }
        for (Directory directory : (List)this.getAllDirectories().get()) {
            directory.getAsFileTree().forEach(file -> {
                String relativePath = directory.getAsFile().toURI().relativize(file.toURI()).getPath().replace(File.separatorChar, '/');
                try (FileInputStream inputStream = new FileInputStream((File)file);){
                    int bytesRead;
                    jarOutput.putNextEntry(new JarEntry(relativePath));
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        jarOutput.write(buffer, 0, bytesRead);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    jarOutput.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        jarOutput.close();
        HashSet<RouteItem> pageSet = new HashSet<RouteItem>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String routeMapString : TheRouterInjects.routeMapStringSet) {
            pageSet.addAll((Collection)gson.fromJson(routeMapString, new TypeToken<List<RouteItem>>(){}.getType()));
        }
        File assetRouteMap = new File(this.getProject().getProjectDir(), "src/main/assets/therouter/routeMap.json");
        if (assetRouteMap.exists()) {
            if ("delete".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                System.out.println("---------TheRouter delete route map------------------------------------------");
                assetRouteMap.delete();
                try {
                    assetRouteMap.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String assetString = null;
                try {
                    assetString = ResourceGroovyMethods.getText((File)assetRouteMap, (String)StandardCharsets.UTF_8.displayName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("---------TheRouter get route map from: /assets/therouter/routeMap.json-------");
                try {
                    ArrayList assetsList = (ArrayList)gson.fromJson(assetString, new TypeToken<List<RouteItem>>(){}.getType());
                    if (assetsList == null) {
                        assetsList = new ArrayList();
                    }
                    for (RouteItem item : assetsList) {
                        if (pageSet.contains(item)) continue;
                        pageSet.add(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("---------TheRouter route map does not exist: /assets/therouter/routeMap.json-------");
            try {
                assetRouteMap.getParentFile().mkdirs();
                assetRouteMap.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<RouteItem>> result = new HashMap<String, ArrayList<RouteItem>>();
        for (RouteItem routeItem : pageSet) {
            Iterator routeList;
            String url = routeItem.path;
            if (url.contains("?")) {
                try {
                    URI uri = new URI(routeItem.path);
                    Map<String, String> map = TheRouterTask.extractQueryParams(uri);
                    routeItem.params.putAll(map);
                    url = url.substring(0, url.indexOf(63));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if ((routeList = (List)result.get(url)) == null) {
                routeList = new ArrayList<RouteItem>();
                result.put(url, (ArrayList<RouteItem>)((Object)routeList));
            }
            routeList.add(routeItem);
        }
        for (List routeItems : result.values()) {
            String className = null;
            for (RouteItem routeItem : routeItems) {
                if (className == null) {
                    className = routeItem.className;
                } else if (!className.equals(routeItem.className)) {
                    throw new RuntimeException("Multiple Activity to single Url: " + className + " and " + routeItem.className);
                }
                if (this.theRouterExtension.checkRouteMap.isEmpty()) continue;
                boolean classNotFound = true;
                for (String item : TheRouterInjects.allClass) {
                    if (!item.contains(routeItem.className.replace(".", "/"))) continue;
                    classNotFound = false;
                    break;
                }
                if (!classNotFound) continue;
                if ("error".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                    throw new ClassNotFoundException(routeItem.className + " in /assets/therouter/routeMap.json");
                }
                if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) continue;
                System.out.println(LogUI.C_WARN.getValue() + "[" + routeItem.className + " in /assets/therouter/routeMap.json]" + LogUI.E_NORMAL.getValue());
            }
        }
        ArrayList pageList = new ArrayList(pageSet);
        Collections.sort(pageList);
        String json = gson.toJson(pageList);
        ResourceGroovyMethods.write((File)assetRouteMap, (String)json, (String)StandardCharsets.UTF_8.displayName());
        System.out.println("---------TheRouter create new route map--------------");
        HashMap<String, Set<String>> flowTaskDependMap = new HashMap<String, Set<String>>();
        for (String key : TheRouterInjects.flowTaskMap.keySet()) {
            String dependsOn;
            HashSet<String> value = (HashSet<String>)flowTaskDependMap.get(key);
            if (value == null) {
                value = new HashSet<String>();
            }
            if ((dependsOn = TheRouterInjects.flowTaskMap.get(key)) != null && !dependsOn.isBlank()) {
                String[] dependencies;
                for (String depend : dependencies = dependsOn.split(",")) {
                    if (depend.isBlank()) continue;
                    value.add(depend.trim());
                }
            }
            flowTaskDependMap.put(key, value);
        }
        if (!this.theRouterExtension.checkFlowDepend.isEmpty()) {
            for (String taskName : flowTaskDependMap.keySet()) {
                Set dependencies = (Set)flowTaskDependMap.get(taskName);
                for (String dependency : dependencies) {
                    if (flowTaskDependMap.containsKey(dependency)) continue;
                    if ("error".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) {
                        throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::\nCan not found Task: [" + dependency + "] from " + taskName + " dependsOn\n==========================================\n\n");
                    }
                    if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) continue;
                    System.out.println();
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::   " + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "Can not found Task: [" + dependency + "] from " + taskName + " dependsOn" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println();
                }
            }
        }
        for (String key : flowTaskDependMap.keySet()) {
            TheRouterPluginUtils.fillTodoList(flowTaskDependMap, key);
        }
        if (this.theRouterExtension.showFlowDepend) {
            for (String key : flowTaskDependMap.keySet()) {
                TheRouterPluginUtils.fillNode(TheRouterPluginUtils.createNode(flowTaskDependMap, key), null);
            }
            System.out.println();
            System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::dependency   " + LogUI.E_NORMAL.getValue());
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            ArrayList<String> dependStack = new ArrayList<String>(TheRouterPluginUtils.dependStack);
            Collections.sort(dependStack);
            for (String it : dependStack) {
                System.out.println(LogUI.C_WARN.getValue() + "[Root --> " + it + "]" + LogUI.E_NORMAL.getValue());
            }
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            System.out.println();
        }
        System.out.println("---------TheRouter check flow task map--------------");
    }

    private void checkBuildCache() throws IOException {
        String text;
        if (this.buildCacheFile.exists() && !(text = TheRouterPluginUtils.getTextFromFile(this.buildCacheFile)).equals(this.buildDataText)) {
            ResourceGroovyMethods.write((File)this.buildDataFile, (String)text, (String)StandardCharsets.UTF_8.displayName());
            if (this.theRouterExtension.debug) {
                File debugFile = new File(this.buildCacheFile.getParentFile(), "previousBuildData.debug");
                if (debugFile.exists()) {
                    debugFile.delete();
                }
                try {
                    debugFile.createNewFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ResourceGroovyMethods.write((File)debugFile, (String)this.buildDataText, (String)StandardCharsets.UTF_8.displayName());
            }
            if (this.theRouterExtension.lang.equals("en")) {
                throw new RuntimeException("\nTheRouter has module additions or removals; please rebuild it again. \nYou can visit the link for more details\uff1a\nhttps://kymjs.com/code/2024/10/31/01/\n\n\n");
            }
            throw new RuntimeException("\nTheRouter \u6709\u6a21\u5757\u589e\u51cf\uff0c\u8bf7\u518d\u6784\u5efa\u4e00\u6b21\u3002\n\u53ef\u8bbf\u95ee\u94fe\u63a5\u67e5\u770b\u8be6\u7ec6\u539f\u56e0\uff1a\nhttps://kymjs.com/code/2024/10/31/01/\n\n\n");
        }
    }

    private static Map<String, String> extractQueryParams(URI uri) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return queryPairs;
    }
}

