/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.therouter.plugin.AddCodeVisitor;
import com.therouter.plugin.agp8.TextParameters;
import com.therouter.plugin.agp8.TheRouterFieldVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;

public abstract class TheRouterASM
implements AsmClassVisitorFactory<TextParameters> {
    public static final String INJECTER_FULL_CLASSNAME = "a.TheRouterServiceProvideInjecter";

    @NotNull
    public ClassVisitor createClassVisitor(@NotNull ClassContext classContext, @NotNull ClassVisitor classVisitor) {
        String currentClassName = classContext.getCurrentClassData().getClassName();
        if (INJECTER_FULL_CLASSNAME.equals(currentClassName)) {
            String buildDataText = (String)((TextParameters)this.getParameters().get()).getBuildDataText().get();
            String[] classNameArray = buildDataText.split("\n");
            HashMap<String, String> serviceProvideMap = new HashMap<String, String>();
            HashSet<String> autowiredSet = new HashSet<String>();
            HashSet<String> routeSet = new HashSet<String>();
            for (String name : classNameArray) {
                if (name.contains("RouterMap__TheRouter__")) {
                    routeSet.add(name.trim());
                    continue;
                }
                if (name.contains("ServiceProvider__TheRouter__")) {
                    serviceProvideMap.put(name.trim().substring(2), "1.2.3-rc6");
                    continue;
                }
                if (!name.contains("__TheRouter__Autowired")) continue;
                autowiredSet.add(name.trim());
            }
            return new AddCodeVisitor(classVisitor, serviceProvideMap, autowiredSet, routeSet, false);
        }
        if (currentClassName.contains("RouterMap__TheRouter__") || currentClassName.contains("ServiceProvider__TheRouter__") || currentClassName.contains("__TheRouter__Autowired")) {
            return new TheRouterFieldVisitor(classVisitor, currentClassName);
        }
        return null;
    }

    public boolean isInstrumentable(@NotNull ClassData classData) {
        if (classData.getClassName().contains("$")) {
            return false;
        }
        String className = classData.getClassName().replaceAll("\\.", "/");
        if (className.contains("RouterMap__TheRouter__") || className.contains("ServiceProvider__TheRouter__") || className.contains("__TheRouter__Autowired")) {
            if (((Boolean)((TextParameters)this.getParameters().get()).getDebugValue().get()).booleanValue()) {
                System.out.println("TheRouter::build.cache -> " + className);
            }
            File buildCacheFile = (File)((TextParameters)this.getParameters().get()).getBuildCacheFile().get();
            try {
                ResourceGroovyMethods.append((File)buildCacheFile, (Object)(className + "\n"), (String)StandardCharsets.UTF_8.displayName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return className.contains("RouterMap__TheRouter__") || className.contains("ServiceProvider__TheRouter__");
        }
        return INJECTER_FULL_CLASSNAME.equals(classData.getClassName());
    }
}

