/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.therouter.plugin.LogUI;
import com.therouter.plugin.RouteItem;
import com.therouter.plugin.TheRouterExtension;
import com.therouter.plugin.TheRouterInjects;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public abstract class TheRouterTask
extends DefaultTask {
    private static final Set<String> allClass = new HashSet<String>();
    private TheRouterExtension theRouterExtension;
    private String buildDataText;
    private File buildCacheFile;
    private File buildDataFile;

    @InputFiles
    public abstract ListProperty<RegularFile> getAllJars();

    @InputFiles
    public abstract ListProperty<Directory> getAllDirectories();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    public void setTheRouterExtension(TheRouterExtension theRouterExtension) {
        this.theRouterExtension = theRouterExtension;
    }

    public void setBuildDataText(String buildDataText) {
        this.buildDataText = buildDataText;
    }

    public void setBuildCacheFile(File buildCacheFile) {
        this.buildCacheFile = buildCacheFile;
    }

    public void setBuildDataFile(File buildDataFile) {
        this.buildDataFile = buildDataFile;
    }

    @TaskAction
    public void taskAction() throws ClassNotFoundException, IOException {
        System.out.println("TheRouter\u7f16\u8bd1\u63d2\u4ef6\uff1a" + LogUI.C_BLACK_GREEN.getValue() + "cn.therouter:plugin:1.2.3-rc5" + LogUI.E_NORMAL.getValue());
        System.out.println("JDK Version::" + System.getProperty("java.version"));
        System.out.println("Gradle Version::" + this.getProject().getGradle().getGradleVersion());
        System.out.println("checkRouteMap::" + this.theRouterExtension.checkRouteMap);
        System.out.println("checkFlowDepend::" + this.theRouterExtension.checkFlowDepend);
        System.out.println("----------------------TheRouter build start------------------------------");
        this.theRouterTransform();
        this.checkBuildCache();
        System.out.println("----------------------TheRouter build finish-----------------------------");
    }

    private void theRouterTransform() throws ClassNotFoundException, IOException {
        File buildDir = (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get();
        File theRouterCacheFolder = new File(buildDir, "therouter");
        theRouterCacheFolder.mkdirs();
        JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(((RegularFile)this.getOutputFile().get()).getAsFile())));
        for (RegularFile file2 : (List)this.getAllJars().get()) {
            File jar = file2.getAsFile();
            JarFile jarFile = new JarFile(jar);
            Iterator e = jarFile.entries();
            while (e.hasMoreElements()) {
                int bytesRead;
                JarEntry jarEntry = e.nextElement();
                jarOutput.putNextEntry(new JarEntry(jarEntry.getName()));
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    jarOutput.write(buffer, 0, bytesRead);
                }
                jarOutput.closeEntry();
            }
            jarFile.close();
        }
        for (Directory directory : (List)this.getAllDirectories().get()) {
            directory.getAsFileTree().forEach(file -> {
                ClassNode cn;
                ClassReader reader;
                String relativePath = directory.getAsFile().toURI().relativize(file.toURI()).getPath().replace(File.separatorChar, '/');
                try {
                    int bytesRead;
                    jarOutput.putNextEntry(new JarEntry(relativePath));
                    FileInputStream inputStream = new FileInputStream((File)file);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        jarOutput.write(buffer, 0, bytesRead);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.tag(relativePath);
                if (TheRouterTask.isRouterMap(relativePath)) {
                    try {
                        reader = new ClassReader((InputStream)new FileInputStream(file.getAbsolutePath()));
                        cn = new ClassNode();
                        reader.accept((ClassVisitor)cn, 0);
                        for (FieldNode fieldNode : cn.fields) {
                            if (!"ROUTERMAP".equals(fieldNode.name)) continue;
                            System.out.println("---------TheRouter in source get route map from: " + relativePath + "-------------------------------");
                            TheRouterInjects.routeMapStringSet.add((String)fieldNode.value);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (TheRouterTask.isServiceProvider(relativePath)) {
                    try {
                        reader = new ClassReader((InputStream)new FileInputStream(file.getAbsolutePath()));
                        cn = new ClassNode();
                        reader.accept((ClassVisitor)cn, 0);
                        for (FieldNode fieldNode : cn.fields) {
                            if (!"FLOW_TASK_JSON".equals(fieldNode.name)) continue;
                            System.out.println("---------TheRouter in source get flow task json from: " + relativePath + "-------------------------------");
                            Map map = (Map)TheRouterInjects.gson.fromJson((String)fieldNode.value, new TypeToken<Map<String, String>>(){}.getType());
                            TheRouterInjects.flowTaskMap.putAll(map);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    jarOutput.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        jarOutput.close();
        HashSet<RouteItem> pageSet = new HashSet<RouteItem>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String routeMapString : TheRouterInjects.routeMapStringSet) {
            pageSet.addAll((Collection)gson.fromJson(routeMapString, new TypeToken<List<RouteItem>>(){}.getType()));
        }
        File assetRouteMap = new File(this.getProject().getProjectDir(), "src/main/assets/therouter/routeMap.json");
        if (assetRouteMap.exists()) {
            if ("delete".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                System.out.println("---------TheRouter delete route map------------------------------------------");
                assetRouteMap.delete();
                try {
                    assetRouteMap.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String assetString = null;
                try {
                    assetString = FileUtils.readFileToString((File)assetRouteMap, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("---------TheRouter get route map from: /assets/therouter/routeMap.json-------");
                try {
                    ArrayList assetsList = (ArrayList)gson.fromJson(assetString, new TypeToken<List<RouteItem>>(){}.getType());
                    if (assetsList == null) {
                        assetsList = new ArrayList();
                    }
                    for (RouteItem item : assetsList) {
                        if (pageSet.contains(item)) continue;
                        pageSet.add(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("---------TheRouter route map does not exist: /assets/therouter/routeMap.json-------");
            try {
                assetRouteMap.getParentFile().mkdirs();
                assetRouteMap.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<RouteItem>> result = new HashMap<String, ArrayList<RouteItem>>();
        for (RouteItem routeItem : pageSet) {
            Iterator routeList;
            String url = routeItem.path;
            if (url.contains("?")) {
                try {
                    URI uri = new URI(routeItem.path);
                    Map<String, String> map = TheRouterTask.extractQueryParams(uri);
                    routeItem.params.putAll(map);
                    url = url.substring(0, url.indexOf(63));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if ((routeList = (List)result.get(url)) == null) {
                routeList = new ArrayList<RouteItem>();
                result.put(url, (ArrayList<RouteItem>)((Object)routeList));
            }
            routeList.add(routeItem);
        }
        for (List routeItems : result.values()) {
            String className = null;
            for (RouteItem routeItem : routeItems) {
                if (className == null) {
                    className = routeItem.className;
                } else if (!className.equals(routeItem.className)) {
                    throw new RuntimeException("Multiple Activity to single Url: " + className + " and " + routeItem.className);
                }
                if (this.theRouterExtension.checkRouteMap.isEmpty()) continue;
                boolean classNotFound = true;
                for (String item : allClass) {
                    if (!item.contains(routeItem.className.replace(".", "/"))) continue;
                    classNotFound = false;
                    break;
                }
                if (!classNotFound) continue;
                if ("error".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                    throw new ClassNotFoundException(routeItem.className + " in /assets/therouter/routeMap.json");
                }
                if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) continue;
                System.out.println(LogUI.C_WARN.getValue() + "[" + routeItem.className + " in /assets/therouter/routeMap.json]" + LogUI.E_NORMAL.getValue());
            }
        }
        ArrayList pageList = new ArrayList(pageSet);
        Collections.sort(pageList);
        String json = gson.toJson(pageList);
        FileUtils.write((File)assetRouteMap, (CharSequence)json, (boolean)false);
        System.out.println("---------TheRouter create new route map--------------");
        HashMap<String, Set<String>> flowTaskDependMap = new HashMap<String, Set<String>>();
        for (String key : TheRouterInjects.flowTaskMap.keySet()) {
            String dependsOn;
            HashSet<String> value = (HashSet<String>)flowTaskDependMap.get(key);
            if (value == null) {
                value = new HashSet<String>();
            }
            if ((dependsOn = TheRouterInjects.flowTaskMap.get(key)) != null && !dependsOn.isBlank()) {
                String[] dependencies;
                for (String depend : dependencies = dependsOn.split(",")) {
                    if (depend.isBlank()) continue;
                    value.add(depend.trim());
                }
            }
            flowTaskDependMap.put(key, value);
        }
        if (!this.theRouterExtension.checkFlowDepend.isEmpty()) {
            for (String taskName : flowTaskDependMap.keySet()) {
                Set dependencies = (Set)flowTaskDependMap.get(taskName);
                for (String dependency : dependencies) {
                    if (flowTaskDependMap.containsKey(dependency)) continue;
                    if ("error".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) {
                        throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::\nCan not found Task: [" + dependency + "] from " + taskName + " dependsOn\n==========================================\n\n");
                    }
                    if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) continue;
                    System.out.println();
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::   " + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "Can not found Task: [" + dependency + "] from " + taskName + " dependsOn" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println();
                }
            }
        }
        for (String key : flowTaskDependMap.keySet()) {
            TheRouterPluginUtils.fillTodoList(flowTaskDependMap, key);
        }
        if (Boolean.valueOf(this.theRouterExtension.showFlowDepend).booleanValue()) {
            for (String key : flowTaskDependMap.keySet()) {
                TheRouterPluginUtils.fillNode(TheRouterPluginUtils.createNode(flowTaskDependMap, key), null);
            }
            System.out.println();
            System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::dependency   " + LogUI.E_NORMAL.getValue());
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            ArrayList<String> dependStack = new ArrayList<String>(TheRouterPluginUtils.dependStack);
            Collections.sort(dependStack);
            for (String it : dependStack) {
                System.out.println(LogUI.C_WARN.getValue() + "[Root --> " + it + "]" + LogUI.E_NORMAL.getValue());
            }
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            System.out.println();
        }
        System.out.println("---------TheRouter check flow task map--------------");
    }

    private void checkBuildCache() throws IOException {
        if (this.buildCacheFile.exists()) {
            StringBuilder dataStringBuilder = new StringBuilder();
            try {
                String[] array = ResourceGroovyMethods.getText((File)this.buildCacheFile, (String)StandardCharsets.UTF_8.displayName()).split("\n");
                HashSet<String> set = new HashSet<String>();
                for (String item : array) {
                    if (item.trim().isBlank()) continue;
                    set.add(item.trim());
                }
                ArrayList list = new ArrayList(set);
                Collections.sort(list);
                for (String item : list) {
                    dataStringBuilder.append(item).append("\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read build.cache file", e);
            }
            if (!dataStringBuilder.toString().equals(this.buildDataText)) {
                ResourceGroovyMethods.write((File)this.buildDataFile, (String)dataStringBuilder.toString(), (String)StandardCharsets.UTF_8.displayName());
                throw new RuntimeException("\n\n\nTheRouter \u6709\u6a21\u5757\u589e\u51cf\uff0c\u8bf7\u518d\u6784\u5efa\u4e00\u6b21\u3002\n\n\n");
            }
        }
    }

    private void debugLog(String log) {
        if (this.theRouterExtension.debug) {
            System.out.println(log);
        }
    }

    private void tag(String className) {
        if (TheRouterTask.isAutowired(className = className.replaceAll(".class", "")) || TheRouterTask.isRouterMap(className) || TheRouterTask.isServiceProvider(className)) {
            try {
                ResourceGroovyMethods.append((File)this.buildCacheFile, (Object)(className + "\n"), (String)StandardCharsets.UTF_8.displayName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static boolean isAutowired(String className) {
        return className.endsWith("__TheRouter__Autowired");
    }

    static boolean isRouterMap(String className) {
        return (className.startsWith("RouterMap__TheRouter__") || className.startsWith("a/RouterMap__TheRouter__")) && !className.contains("\\$");
    }

    static boolean isServiceProvider(String className) {
        return (className.startsWith("ServiceProvider__TheRouter__") || className.startsWith("a/ServiceProvider__TheRouter__")) && !className.contains("\\$");
    }

    private static Map<String, String> extractQueryParams(URI uri) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return queryPairs;
    }
}

