package com.therouter.plugin;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.api.variant.Variant;
import com.therouter.plugin.agp8.TextParameters;
import com.therouter.plugin.agp8.TheRouterASM;
import com.therouter.plugin.agp8.TheRouterTask;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class TheRouterPlugin implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        TheRouterExtension theRouterExtension = project.getExtensions().create("TheRouter", TheRouterExtension.class);

        boolean isLibrary = project.getPlugins().hasPlugin("com.android.library");
        if (!isLibrary) {
            AndroidComponentsExtension<?, ?, Variant> android = project.getExtensions().getByType(AndroidComponentsExtension.class);
            android.onVariants(android.selector().all(), new Action<Variant>() {
                @Override
                public void execute(Variant variant) {
                    File buildCacheFile = new File(project.getProjectDir(), "src/main/assets/therouter/build.cache");
                    String text = "";
                    if (buildCacheFile.exists()) {
                        try {
                            text = Files.readString(buildCacheFile.toPath(), StandardCharsets.UTF_8);
                        } catch (IOException e) {
                            throw new RuntimeException("Failed to read build.cache file", e);
                        }
                    }
                    final String buildCacheText = text;
                    System.out.println("========222=1======" + text);
                    variant.getInstrumentation().transformClassesWith(TheRouterASM.class, InstrumentationScope.ALL, new Function1<TextParameters, Unit>() {
                        @Override
                        public Unit invoke(TextParameters textParameters) {
                            System.out.println("========222=2======");
                            textParameters.getBuildCacheText().set(buildCacheText);
                            return null;
                        }
                    });

                    System.out.println("========1111=1======");
                    TaskProvider<TheRouterTask> getAllClassesTask = project.getTasks().register(variant.getName() + "TheRouter", TheRouterTask.class, task -> {
                        System.out.println("========1111=2======");
                        task.setTheRouterExtension(theRouterExtension);
                    });

                    System.out.println("========1=======");
                    variant.getArtifacts()
                            .forScope(ScopedArtifacts.Scope.ALL)
                            .use(getAllClassesTask)
                            .toGet(ScopedArtifact.CLASSES.INSTANCE,
                                    TheRouterTask::getAllJars,
                                    TheRouterTask::getAllDirectories);
                    System.out.println("========2=======");
                }
            });
        } else {
            throw new RuntimeException("`apply plugin: 'therouter'` must be applied in the app module! Remove it from module " + project.getName() + ".");
        }
    }
}