package com.therouter.plugin.agp8;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.therouter.plugin.AddCodeVisitor;
import com.therouter.plugin.BuildConfig;
import com.therouter.plugin.TheRouterInjects;

import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TheRouterASM implements AsmClassVisitorFactory<TextParameters> {

    @NotNull
    @Override
    public ClassVisitor createClassVisitor(@NotNull ClassContext classContext, @NotNull ClassVisitor classVisitor) {
        String buildCacheText = getParameters().get().getBuildCacheText().get();
        String[] classNameArray = buildCacheText.split("\n");
        Map<String, String> serviceProvideMap = new HashMap<>();
        Set<String> autowiredSet = new HashSet<>();
        Set<String> routeSet = new HashSet<>();
        for (String name : classNameArray) {
            if (name.contains(TheRouterInjects.PREFIX_ROUTER_MAP)) {
                routeSet.add(name);
            } else if (name.contains(TheRouterInjects.PREFIX_SERVICE_PROVIDER)) {
                serviceProvideMap.put(name.substring(2), BuildConfig.VERSION);
            } else if (name.contains(TheRouterInjects.SUFFIX_AUTOWIRED)) {
                autowiredSet.add(name);
            }
        }
        return new AddCodeVisitor(classVisitor, serviceProvideMap, autowiredSet, routeSet, false);
    }

    @Override
    public boolean isInstrumentable(@NotNull ClassData classData) {
        return "a.TheRouterServiceProvideInjecter".equals(classData.getClassName());
    }
}