package com.therouter.plugin

import com.android.build.api.artifact.ScopedArtifact
import com.android.build.api.instrumentation.InstrumentationScope
import com.android.build.api.variant.AndroidComponentsExtension
import com.android.build.api.variant.ScopedArtifacts
import com.android.build.api.variant.Variant
import com.therouter.plugin.agp8.TheRouterASM

//import com.android.build.gradle.AppExtension

import com.therouter.plugin.agp8.TheRouterTask

import org.gradle.api.Action
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.tasks.TaskProvider

public class TheRouterPlugin implements Plugin<Project> {
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final String DELETE = "delete";

    @Override
    void apply(Project project) {
        TheRouterExtension theRouterExtension = project.extensions.create('TheRouter', TheRouterExtension)
        File buildCacheFile = new File(project.getProjectDir(), "src/main/assets/therouter/build.cache");
        String buildCacheText = "";
        if (buildCacheFile.exists()) {
            buildCacheText = buildCacheFile.getText("UTF-8")
        }

        boolean isLibrary = project.getPlugins().hasPlugin("com.android.library")
        if (!isLibrary) {
            def android = project.extensions.getByType(AndroidComponentsExtension.class)
            android.onVariants(android.selector().all(), new Action<Variant>() {
                @Override
                void execute(Variant variant) {
                    TaskProvider<TheRouterTask> getAllClassesTask = project.tasks.register("${variant.name}TheRouter", TheRouterTask.class, task -> {
                        task.setTheRouterExtension(theRouterExtension);
                    })
                    variant.artifacts
                            .forScope(ScopedArtifacts.Scope.ALL)
                            .use(getAllClassesTask)
                            .toGet(ScopedArtifact.CLASSES.INSTANCE,
                                    task -> task.getAllJars(),
                                    task -> task.getAllDirectories())

                    variant.instrumentation.transformClassesWith(TheRouterASM.class, InstrumentationScope.ALL) { p ->
                        p.getBuildCacheText().set(buildCacheText)
                    }.setAsmFramesComputationMode(FramesComputationMode.COPY_FRAMES)
                }
            })
        } else {
            throw new RuntimeException("`apply plugin: 'therouter'` must call in app module! You need remove at ${project.name} module.")
        }
    }
}