/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.therouter.plugin.JarInfo;
import com.therouter.plugin.LogUI;
import com.therouter.plugin.RouteItem;
import com.therouter.plugin.TheRouterExtension;
import com.therouter.plugin.TheRouterInjects;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public abstract class TheRouterTask
extends DefaultTask {
    private static final Set<String> allClass = new HashSet<String>();
    private TheRouterExtension theRouterExtension;

    @InputFiles
    public abstract ListProperty<RegularFile> getAllJars();

    @InputFiles
    public abstract ListProperty<Directory> getAllDirectories();

    public void setTheRouterExtension(TheRouterExtension theRouterExtension) {
        this.theRouterExtension = theRouterExtension;
    }

    @TaskAction
    public void taskAction() throws ClassNotFoundException, IOException {
        this.theRouterTransform();
        System.out.println("----------------------TheRouter build finish-----------------------------");
    }

    private void theRouterTransform() throws ClassNotFoundException, IOException {
        HashSet routeMapStringSet = new HashSet();
        HashMap flowTaskMap = new HashMap();
        File buildDir = (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get();
        File theRouterCacheFolder = new File(buildDir, "therouter");
        theRouterCacheFolder.mkdirs();
        for (RegularFile file2 : (List)this.getAllJars().get()) {
            JarInfo jarInfo;
            File jar = file2.getAsFile();
            String jarName = jar.getName().toLowerCase();
            String cacheName = jarName.equals("classes.jar") ? "classes-" + Math.abs(jar.getAbsolutePath().hashCode()) + ".jar" : jarName;
            File cacheFile = new File(theRouterCacheFolder, cacheName);
            String logInfo = "---------TheRouter handle jar " + jarName + "  ";
            if (cacheFile.exists()) {
                jarInfo = TheRouterInjects.fromCache(cacheFile);
                if (jar.length() != jarInfo.lastModified) {
                    this.debugLog(logInfo + "CHANGED");
                    cacheFile.delete();
                    jarInfo = TheRouterInjects.tagJar(jar);
                    jarInfo.lastModified = jar.length();
                    TheRouterInjects.toCache(cacheFile, jarInfo);
                } else {
                    this.debugLog(logInfo + "UP-TO-DATE");
                }
            } else {
                this.debugLog(logInfo + "EMPTY_CACHE");
                jarInfo = TheRouterInjects.tagJar(jar);
                jarInfo.lastModified = jar.length();
                TheRouterInjects.toCache(cacheFile, jarInfo);
            }
            allClass.addAll(jarInfo.allJarClass);
        }
        for (Directory directory : (List)this.getAllDirectories().get()) {
            directory.getAsFileTree().forEach(file -> {
                String relativePath = directory.getAsFile().toURI().relativize(file.toURI()).getPath().replace(File.separatorChar, '/');
                TheRouterTask.tag(relativePath);
                if (TheRouterTask.isRouterMap(relativePath)) {
                    try {
                        ClassReader reader = new ClassReader((InputStream)new FileInputStream(file.getAbsolutePath()));
                        ClassNode cn = new ClassNode();
                        reader.accept((ClassVisitor)cn, 0);
                        for (FieldNode fieldNode : cn.fields) {
                            if (!"ROUTERMAP".equals(fieldNode.name)) continue;
                            System.out.println("---------TheRouter in jar get route map from: " + relativePath + "-------------------------------");
                            routeMapStringSet.add((String)fieldNode.value);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (TheRouterTask.isServiceProvider(relativePath)) {
                    try {
                        ClassReader reader = new ClassReader((InputStream)new FileInputStream(file.getAbsolutePath()));
                        ClassNode cn = new ClassNode();
                        reader.accept((ClassVisitor)cn, 0);
                        for (FieldNode fieldNode : cn.fields) {
                            if (!"FLOW_TASK_JSON".equals(fieldNode.name)) continue;
                            System.out.println("---------TheRouter in jar get flow task json from: " + relativePath + "-------------------------------");
                            Map map = (Map)TheRouterInjects.gson.fromJson((String)fieldNode.value, new TypeToken<Map<String, String>>(){}.getType());
                            flowTaskMap.putAll(map);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        TheRouterInjects.writeBuildCacheFile();
        HashSet<RouteItem> pageSet = new HashSet<RouteItem>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String routeMapString : routeMapStringSet) {
            pageSet.addAll((Collection)gson.fromJson(routeMapString, new TypeToken<List<RouteItem>>(){}.getType()));
        }
        File assetRouteMap = new File(this.getProject().getProjectDir(), "src/main/assets/therouter/routeMap.json");
        if (assetRouteMap.exists()) {
            if ("delete".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                System.out.println("---------TheRouter delete route map------------------------------------------");
                assetRouteMap.delete();
                try {
                    assetRouteMap.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String assetString = null;
                try {
                    assetString = FileUtils.readFileToString((File)assetRouteMap, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("---------TheRouter get route map from: /assets/therouter/routeMap.json-------");
                try {
                    ArrayList assetsList = (ArrayList)gson.fromJson(assetString, new TypeToken<List<RouteItem>>(){}.getType());
                    if (assetsList == null) {
                        assetsList = new ArrayList();
                    }
                    for (RouteItem item : assetsList) {
                        if (pageSet.contains(item)) continue;
                        pageSet.add(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("---------TheRouter route map does not exist: /assets/therouter/routeMap.json-------");
            try {
                assetRouteMap.getParentFile().mkdirs();
                assetRouteMap.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<RouteItem>> result = new HashMap<String, ArrayList<RouteItem>>();
        for (RouteItem routeItem : pageSet) {
            Iterator routeList;
            String url = routeItem.path;
            if (url.contains("?")) {
                try {
                    URI uri = new URI(routeItem.path);
                    Map<String, String> map = TheRouterTask.extractQueryParams(uri);
                    routeItem.params.putAll(map);
                    url = url.substring(0, url.indexOf(63));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if ((routeList = (List)result.get(url)) == null) {
                routeList = new ArrayList<RouteItem>();
                result.put(url, (ArrayList<RouteItem>)((Object)routeList));
            }
            routeList.add(routeItem);
        }
        for (List routeItems : result.values()) {
            String className = null;
            for (RouteItem routeItem : routeItems) {
                if (className == null) {
                    className = routeItem.className;
                } else if (!className.equals(routeItem.className)) {
                    throw new RuntimeException("Multiple Activity to single Url: " + className + " and " + routeItem.className);
                }
                if (this.theRouterExtension.checkRouteMap.isEmpty()) continue;
                boolean classNotFound = true;
                for (String item : allClass) {
                    if (!item.contains(routeItem.className.replace(".", "/"))) continue;
                    classNotFound = false;
                    break;
                }
                if (!classNotFound) continue;
                if ("error".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                    throw new ClassNotFoundException(routeItem.className + " in /assets/therouter/routeMap.json");
                }
                if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) continue;
                System.out.println(LogUI.C_WARN.getValue() + "[" + routeItem.className + " in /assets/therouter/routeMap.json]" + LogUI.E_NORMAL.getValue());
            }
        }
        ArrayList pageList = new ArrayList(pageSet);
        Collections.sort(pageList);
        String json = gson.toJson(pageList);
        FileUtils.write((File)assetRouteMap, (CharSequence)json, (boolean)false);
        System.out.println("---------TheRouter create new route map--------------");
        HashMap<String, Set<String>> flowTaskDependMap = new HashMap<String, Set<String>>();
        for (String key : flowTaskMap.keySet()) {
            String dependsOn;
            HashSet<String> value = (HashSet<String>)flowTaskDependMap.get(key);
            if (value == null) {
                value = new HashSet<String>();
            }
            if ((dependsOn = (String)flowTaskMap.get(key)) != null && !dependsOn.isBlank()) {
                String[] dependencies;
                for (String depend : dependencies = dependsOn.split(",")) {
                    if (depend.isBlank()) continue;
                    value.add(depend.trim());
                }
            }
            flowTaskDependMap.put(key, value);
        }
        if (!this.theRouterExtension.checkFlowDepend.isEmpty()) {
            for (String taskName : flowTaskDependMap.keySet()) {
                Set dependencies = (Set)flowTaskDependMap.get(taskName);
                for (String dependency : dependencies) {
                    if (flowTaskDependMap.containsKey(dependency)) continue;
                    if ("error".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) {
                        throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::\nCan not found Task: [" + dependency + "] from " + taskName + " dependsOn\n==========================================\n\n");
                    }
                    if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) continue;
                    System.out.println();
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::   " + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "Can not found Task: [" + dependency + "] from " + taskName + " dependsOn" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println();
                }
            }
        }
        for (String key : flowTaskDependMap.keySet()) {
            TheRouterPluginUtils.fillTodoList(flowTaskDependMap, key);
        }
        if (Boolean.valueOf(this.theRouterExtension.showFlowDepend).booleanValue()) {
            for (String key : flowTaskDependMap.keySet()) {
                TheRouterPluginUtils.fillNode(TheRouterPluginUtils.createNode(flowTaskDependMap, key), null);
            }
            System.out.println();
            System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::dependency   " + LogUI.E_NORMAL.getValue());
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            ArrayList<String> dependStack = new ArrayList<String>(TheRouterPluginUtils.dependStack);
            Collections.sort(dependStack);
            for (String it : dependStack) {
                System.out.println(LogUI.C_WARN.getValue() + "[Root --> " + it + "]" + LogUI.E_NORMAL.getValue());
            }
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            System.out.println();
        }
        System.out.println("---------TheRouter check flow task map--------------");
    }

    private void debugLog(String log) {
        if (this.theRouterExtension.debug) {
            System.out.println(log);
        }
    }

    private static void tag(String className) {
        if (TheRouterTask.isAutowired(className = className.replaceAll(".class", ""))) {
            TheRouterInjects.autowiredSet.add(className);
        } else if (TheRouterTask.isRouterMap(className)) {
            TheRouterInjects.routeSet.add(className);
        } else if (TheRouterTask.isServiceProvider(className)) {
            TheRouterInjects.serviceProvideMap.put(className, "1.2.3-rc4");
        }
    }

    static boolean isAutowired(String className) {
        return className.endsWith("__TheRouter__Autowired");
    }

    static boolean isRouterMap(String className) {
        return (className.startsWith("RouterMap__TheRouter__") || className.startsWith("a/RouterMap__TheRouter__")) && !className.contains("\\$");
    }

    static boolean isServiceProvider(String className) {
        return (className.startsWith("ServiceProvider__TheRouter__") || className.startsWith("a/ServiceProvider__TheRouter__")) && !className.contains("\\$");
    }

    private static Map<String, String> extractQueryParams(URI uri) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return queryPairs;
    }
}

