/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.therouter.plugin.AddCodeVisitor;
import com.therouter.plugin.JarInfo;
import com.therouter.plugin.LogUI;
import com.therouter.plugin.RouteItem;
import com.therouter.plugin.TheRouterExtension;
import com.therouter.plugin.TheRouterInjects;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public abstract class TheRouterTask
extends DefaultTask {
    private static final Set<String> allClass = new HashSet<String>();
    private static final Set<String> mergeClass = new HashSet<String>();
    private static final TheRouterExtension theRouterExtension = new TheRouterExtension();

    @InputFiles
    public abstract ListProperty<RegularFile> getAllJars();

    @InputFiles
    public abstract ListProperty<Directory> getAllDirectories();

    @OutputDirectory
    public abstract RegularFileProperty getOutputDirectory();

    @TaskAction
    public void taskAction() throws ClassNotFoundException, IOException {
        if (this.getProject().hasProperty("TheRouter")) {
            TheRouterTask.theRouterExtension.debug = Boolean.parseBoolean((String)this.getProject().property("TheRouter.debug"));
            TheRouterTask.theRouterExtension.checkRouteMap = (String)this.getProject().property("TheRouter.checkRouteMap");
            TheRouterTask.theRouterExtension.checkFlowDepend = (String)this.getProject().property("TheRouter.checkFlowDepend");
            TheRouterTask.theRouterExtension.showFlowDepend = Boolean.parseBoolean((String)this.getProject().property("TheRouter.showFlowDepend"));
        }
        System.out.println("TheRouter\u7f16\u8bd1\u63d2\u4ef6\uff1a" + LogUI.C_BLACK_GREEN.getValue() + "cn.therouter:plugin:1.2.3-rc1" + LogUI.E_NORMAL.getValue());
        System.out.println("JDK Version::" + System.getProperty("java.version"));
        System.out.println("Gradle Version::" + this.getProject().getGradle().getGradleVersion());
        System.out.println("checkRouteMap::" + TheRouterTask.theRouterExtension.checkRouteMap);
        System.out.println("checkFlowDepend::" + TheRouterTask.theRouterExtension.checkFlowDepend);
        System.out.println("----------------------TheRouter build start------------------------------");
        this.theRouterTransform();
        System.out.println("----------------------TheRouter build finish-----------------------------");
    }

    private void theRouterTransform() throws ClassNotFoundException, IOException {
        String theRouterInjectEntryName = null;
        HashSet routeMapStringSet = new HashSet();
        HashMap flowTaskMap = new HashMap();
        File dest = ((RegularFile)this.getOutputDirectory().get()).getAsFile();
        System.out.println("========output==" + dest.getAbsolutePath());
        if (dest.isDirectory()) {
            FileUtils.deleteDirectory((File)dest);
        } else {
            dest.delete();
        }
        HashSet<File> changedJarHighLevel = new HashSet<File>();
        HashSet<File> changedJarMiddleLevel = new HashSet<File>();
        HashSet<File> changedJarLowLevel = new HashSet<File>();
        File theRouterCacheFolder = new File(this.getProject().getBuildDir(), "therouter");
        theRouterCacheFolder.mkdirs();
        File theRouterDest = new File(theRouterCacheFolder, "therouter-dest-cache.jar");
        if (!theRouterDest.exists() || !TheRouterTask.theRouterExtension.debug) {
            theRouterCacheFolder.delete();
            theRouterCacheFolder.mkdirs();
            theRouterDest.delete();
            mergeClass.clear();
        } else {
            changedJarLowLevel.add(theRouterDest);
        }
        for (Object file : (List)this.getAllJars().get()) {
            JarInfo jarInfo;
            File jar = file.getAsFile();
            String jarName = jar.getName().toLowerCase();
            String cacheName = jarName.equals("classes.jar") ? "classes-" + Math.abs(jar.getAbsolutePath().hashCode()) + ".jar" : jarName;
            File cacheFile = new File(theRouterCacheFolder, cacheName);
            String logInfo = "---------TheRouter handle jar " + jarName + "  ";
            if (cacheFile.exists()) {
                jarInfo = TheRouterInjects.fromCache(cacheFile);
                if (jar.length() != jarInfo.lastModified) {
                    TheRouterTask.debugLog(logInfo + "CHANGED");
                    cacheFile.delete();
                    jarInfo = TheRouterInjects.tagJar(jar);
                    jarInfo.lastModified = jar.length();
                    TheRouterInjects.toCache(cacheFile, jarInfo);
                    changedJarHighLevel.add(jar);
                } else {
                    TheRouterTask.debugLog(logInfo + "UP-TO-DATE");
                }
            } else {
                TheRouterTask.debugLog(logInfo + "EMPTY_CACHE");
                jarInfo = TheRouterInjects.tagJar(jar);
                jarInfo.lastModified = jar.length();
                TheRouterInjects.toCache(cacheFile, jarInfo);
                changedJarHighLevel.add(jar);
            }
            if (!jarInfo.isTheRouterJar) continue;
            changedJarMiddleLevel.add(jar);
            theRouterInjectEntryName = jarInfo.theRouterInjectEntryName;
            TheRouterTask.debugLog("---------TheRouter jar path is " + jar.getAbsolutePath());
        }
        try (JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));){
            for (Object directory : (List)this.getAllDirectories().get()) {
                directory.getAsFileTree().forEach(arg_0 -> this.lambda$theRouterTransform$0((Directory)directory, jarOutput, routeMapStringSet, flowTaskMap, arg_0));
            }
            TheRouterTask.mergeJar(jarOutput, changedJarHighLevel, theRouterInjectEntryName);
            TheRouterTask.mergeJar(jarOutput, changedJarMiddleLevel, theRouterInjectEntryName);
            TheRouterTask.mergeJar(jarOutput, changedJarLowLevel, theRouterInjectEntryName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            FileUtils.copyFile((File)dest, (File)theRouterDest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mergeClass.clear();
        System.out.println("---------TheRouter ASM finish----------------------");
        HashSet<RouteItem> pageSet = new HashSet<RouteItem>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String routeMapString : routeMapStringSet) {
            pageSet.addAll((Collection)gson.fromJson(routeMapString, new TypeToken<List<RouteItem>>(){}.getType()));
        }
        File assetRouteMap = new File(this.getProject().getProjectDir(), "src/main/assets/therouter/routeMap.json");
        if (assetRouteMap.exists()) {
            if ("delete".equalsIgnoreCase(TheRouterTask.theRouterExtension.checkRouteMap)) {
                System.out.println("---------TheRouter delete route map------------------------------------------");
                assetRouteMap.delete();
                try {
                    assetRouteMap.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String assetString = null;
                try {
                    assetString = FileUtils.readFileToString((File)assetRouteMap, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("---------TheRouter get route map from: /assets/therouter/routeMap.json-------");
                try {
                    List assetsList = (List)gson.fromJson(assetString, new TypeToken<List<RouteItem>>(){}.getType());
                    for (RouteItem item : assetsList) {
                        if (pageSet.contains(item)) continue;
                        pageSet.add(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("---------TheRouter route map does not exist: /assets/therouter/routeMap.json-------");
            try {
                assetRouteMap.getParentFile().mkdirs();
                assetRouteMap.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<RouteItem>> result = new HashMap<String, ArrayList<RouteItem>>();
        for (RouteItem routeItem : pageSet) {
            Iterator routeList;
            String url = routeItem.path;
            if (url.contains("?")) {
                try {
                    URI uri = new URI(routeItem.path);
                    Map<String, String> map = TheRouterTask.extractQueryParams(uri);
                    routeItem.params.putAll(map);
                    url = url.substring(0, url.indexOf(63));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if ((routeList = (List)result.get(url)) == null) {
                routeList = new ArrayList<RouteItem>();
                result.put(url, (ArrayList<RouteItem>)((Object)routeList));
            }
            routeList.add(routeItem);
        }
        for (List routeItems : result.values()) {
            String className = null;
            for (RouteItem routeItem : routeItems) {
                if (className == null) {
                    className = routeItem.className;
                } else if (!className.equals(routeItem.className)) {
                    throw new RuntimeException("Multiple Activity to single Url: " + className + " and " + routeItem.className);
                }
                if (TheRouterTask.theRouterExtension.checkRouteMap.isEmpty()) continue;
                boolean classNotFound = true;
                for (String item : mergeClass) {
                    if (!item.contains(routeItem.className.replace(".", "/"))) continue;
                    classNotFound = false;
                    break;
                }
                if (!classNotFound) continue;
                if ("error".equalsIgnoreCase(TheRouterTask.theRouterExtension.checkRouteMap)) {
                    throw new ClassNotFoundException(routeItem.className + " in /assets/therouter/routeMap.json");
                }
                if (!"warning".equalsIgnoreCase(TheRouterTask.theRouterExtension.checkRouteMap)) continue;
                System.out.println(LogUI.C_WARN.getValue() + "[" + routeItem.className + " in /assets/therouter/routeMap.json]" + LogUI.E_NORMAL.getValue());
            }
        }
        ArrayList pageList = new ArrayList(pageSet);
        Collections.sort(pageList);
        String json = gson.toJson(pageList);
        FileUtils.write((File)assetRouteMap, (CharSequence)json, (boolean)false);
        System.out.println("---------TheRouter create new route map--------------");
        HashMap<String, Set<String>> flowTaskDependMap = new HashMap<String, Set<String>>();
        for (String key : flowTaskMap.keySet()) {
            String dependsOn;
            HashSet<String> value = (HashSet<String>)flowTaskDependMap.get(key);
            if (value == null) {
                value = new HashSet<String>();
            }
            if ((dependsOn = (String)flowTaskMap.get(key)) != null && !dependsOn.isBlank()) {
                String[] dependencies;
                for (String depend : dependencies = dependsOn.split(",")) {
                    if (depend.isBlank()) continue;
                    value.add(depend.trim());
                }
            }
            flowTaskDependMap.put(key, value);
        }
        if (!TheRouterTask.theRouterExtension.checkFlowDepend.isEmpty()) {
            for (String taskName : flowTaskDependMap.keySet()) {
                Set dependencies = (Set)flowTaskDependMap.get(taskName);
                for (String dependency : dependencies) {
                    if (flowTaskDependMap.containsKey(dependency)) continue;
                    if ("error".equalsIgnoreCase(TheRouterTask.theRouterExtension.checkFlowDepend)) {
                        throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::\nCan not found Task: [" + dependency + "] from " + taskName + " dependsOn\n==========================================\n\n");
                    }
                    if (!"warning".equalsIgnoreCase(TheRouterTask.theRouterExtension.checkFlowDepend)) continue;
                    System.out.println();
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::   " + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "Can not found Task: [" + dependency + "] from " + taskName + " dependsOn" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println();
                }
            }
        }
        for (String key : flowTaskDependMap.keySet()) {
            TheRouterPluginUtils.fillTodoList(flowTaskDependMap, key);
        }
        if (Boolean.valueOf(TheRouterTask.theRouterExtension.showFlowDepend).booleanValue()) {
            for (String key : flowTaskDependMap.keySet()) {
                TheRouterPluginUtils.fillNode(TheRouterPluginUtils.createNode(flowTaskDependMap, key), null);
            }
            System.out.println();
            System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::dependency   " + LogUI.E_NORMAL.getValue());
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            ArrayList<String> dependStack = new ArrayList<String>(TheRouterPluginUtils.dependStack);
            Collections.sort(dependStack);
            for (String it : dependStack) {
                System.out.println(LogUI.C_WARN.getValue() + "[Root --> " + it + "]" + LogUI.E_NORMAL.getValue());
            }
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            System.out.println();
        }
        System.out.println("---------TheRouter check flow task map--------------");
    }

    private static void debugLog(String log) {
        if (TheRouterTask.theRouterExtension.debug) {
            System.out.println(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeJar(JarOutputStream jos, Set<File> jarFiles, String theRouterInjectEntryName) throws IOException {
        for (File jar : jarFiles) {
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                try {
                    JarEntry entry = entries.nextElement();
                    if (mergeClass.contains(entry.getName())) continue;
                    jos.putNextEntry(new JarEntry(entry.getName()));
                    try (InputStream inputStream = jarFile.getInputStream(entry);){
                        if (entry.getName().equals(theRouterInjectEntryName)) {
                            ClassReader cr = new ClassReader(inputStream);
                            ClassWriter cw = new ClassWriter(2);
                            AddCodeVisitor cv = new AddCodeVisitor((ClassVisitor)cw, TheRouterInjects.serviceProvideMap, TheRouterInjects.autowiredSet, TheRouterInjects.routeSet, false);
                            cr.accept((ClassVisitor)cv, 2);
                            byte[] bytes = cw.toByteArray();
                            jos.write(bytes);
                        } else {
                            int len;
                            byte[] buffer = new byte[1024];
                            while ((len = inputStream.read(buffer)) != -1) {
                                jos.write(buffer, 0, len);
                            }
                        }
                    }
                    mergeClass.add(entry.getName());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                finally {
                    jos.closeEntry();
                }
            }
        }
    }

    private static void tag(String className) {
        if (TheRouterTask.isAutowired(className = className.replaceAll(".class", ""))) {
            TheRouterInjects.autowiredSet.add(className);
        } else if (TheRouterTask.isRouterMap(className)) {
            TheRouterInjects.routeSet.add(className);
        } else if (TheRouterTask.isServiceProvider(className)) {
            TheRouterInjects.serviceProvideMap.put(className, "1.2.3-rc1");
        }
    }

    static boolean isAutowired(String className) {
        return className.endsWith("__TheRouter__Autowired");
    }

    static boolean isRouterMap(String className) {
        return (className.startsWith("RouterMap__TheRouter__") || className.startsWith("a/RouterMap__TheRouter__")) && !className.contains("\\$");
    }

    static boolean isServiceProvider(String className) {
        return (className.startsWith("ServiceProvider__TheRouter__") || className.startsWith("a/ServiceProvider__TheRouter__")) && !className.contains("\\$");
    }

    private static Map<String, String> extractQueryParams(URI uri) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return queryPairs;
    }

    private /* synthetic */ void lambda$theRouterTransform$0(Directory directory, JarOutputStream jarOutput, Set routeMapStringSet, Map flowTaskMap, File file) {
        String relativePath = directory.getAsFile().toURI().relativize(file.toURI()).getPath().replace(File.separatorChar, '/');
        try {
            jarOutput.putNextEntry(new JarEntry(relativePath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TheRouterTask.tag(relativePath);
        mergeClass.add(relativePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            if (TheRouterTask.isRouterMap(relativePath)) {
                ClassReader reader = new ClassReader((InputStream)new FileInputStream(file.getAbsolutePath()));
                ClassNode cn = new ClassNode();
                reader.accept((ClassVisitor)cn, 0);
                for (FieldNode fieldNode : cn.fields) {
                    if (!"ROUTERMAP".equals(fieldNode.name)) continue;
                    System.out.println("---------TheRouter in jar get route map from: " + relativePath + "-------------------------------");
                    routeMapStringSet.add((String)fieldNode.value);
                }
            } else if (TheRouterTask.isServiceProvider(relativePath)) {
                ClassReader reader = new ClassReader((InputStream)new FileInputStream(file.getAbsolutePath()));
                ClassNode cn = new ClassNode();
                reader.accept((ClassVisitor)cn, 0);
                for (FieldNode fieldNode : cn.fields) {
                    if (!"FLOW_TASK_JSON".equals(fieldNode.name)) continue;
                    System.out.println("---------TheRouter in jar get flow task json from: " + relativePath + "-------------------------------");
                    Map map = (Map)TheRouterInjects.gson.fromJson((String)fieldNode.value, new TypeToken<Map<String, String>>(){}.getType());
                    flowTaskMap.putAll(map);
                }
            }
            jarOutput.write(((InputStream)inputStream).readAllBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            jarOutput.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

