/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.api.variant.Variant;
import com.therouter.plugin.TheRouterExtension;
import com.therouter.plugin.agp8.TextParameters;
import com.therouter.plugin.agp8.TheRouterASM;
import com.therouter.plugin.agp8.TheRouterTask;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.File;
import java.io.IOException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskProvider;

public abstract class AGP8Plugin
implements Plugin<Project> {
    public void applyPlugin(final Project project, final TheRouterExtension theRouterExtension) {
        boolean isFirst;
        final File flowTaskFile = new File(((Directory)project.getLayout().getBuildDirectory().get()).getAsFile(), "therouter/flowtask.data");
        final File routeFile = new File(((Directory)project.getLayout().getBuildDirectory().get()).getAsFile(), "therouter/route.data");
        final File asmTargetFile = new File(((Directory)project.getLayout().getBuildDirectory().get()).getAsFile(), "therouter/asm.data");
        final File allClassFile = new File(((Directory)project.getLayout().getBuildDirectory().get()).getAsFile(), "therouter/all.data");
        boolean bl = isFirst = !asmTargetFile.exists();
        if (isFirst) {
            if (asmTargetFile.exists()) {
                asmTargetFile.delete();
            }
            asmTargetFile.getParentFile().mkdirs();
            try {
                asmTargetFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        AndroidComponentsExtension android = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        android.onVariants(android.selector().all(), (Action)new Action<Variant>(){

            public void execute(Variant variant) {
                if (TheRouterPluginUtils.needTagClass(theRouterExtension.checkRouteMap) && !allClassFile.exists()) {
                    allClassFile.getParentFile().mkdirs();
                    try {
                        allClassFile.createNewFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                ScopedArtifacts.Scope scope = ScopedArtifacts.Scope.ALL;
                if (!isFirst) {
                    scope = ScopedArtifacts.Scope.PROJECT;
                    String tempText = "";
                    if (TheRouterPluginUtils.needTagClass(theRouterExtension.checkRouteMap)) {
                        tempText = TheRouterPluginUtils.getTextFromFile(allClassFile);
                    }
                    final String allClassText = tempText;
                    final String asmTargetText = TheRouterPluginUtils.getTextFromFile(asmTargetFile);
                    variant.getInstrumentation().transformClassesWith(TheRouterASM.class, InstrumentationScope.ALL, (Function1)new Function1<TextParameters, Unit>(){

                        public Unit invoke(TextParameters textParameters) {
                            textParameters.getAsmTargetText().set((Object)asmTargetText);
                            textParameters.getAllClassText().set((Object)allClassText);
                            textParameters.getAsmTargetFile().set((Object)asmTargetFile);
                            textParameters.getAllClassFile().set((Object)allClassFile);
                            textParameters.getFlowTaskFile().set((Object)flowTaskFile);
                            textParameters.getRouteFile().set((Object)routeFile);
                            textParameters.getDebugValue().set((Object)theRouterExtension.debug);
                            textParameters.getCheckRouteMapValue().set((Object)theRouterExtension.checkRouteMap);
                            textParameters.getCheckFlowDependValue().set((Object)theRouterExtension.checkFlowDepend);
                            return null;
                        }
                    });
                }
                String variantName = "TheRouter" + variant.getName().substring(0, 1).toUpperCase() + variant.getName().substring(1);
                TaskProvider theRouterTask = project.getTasks().register(variantName, TheRouterTask.class, task -> {
                    task.setTheRouterExtension(theRouterExtension);
                    task.setAsmTargetFile(asmTargetFile);
                    task.setAllClassFile(allClassFile);
                    task.setFlowTaskFile(flowTaskFile);
                    task.setRouteFile(routeFile);
                    task.setFirst(isFirst);
                });
                variant.getArtifacts().forScope(scope).use(theRouterTask).toTransform((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, TheRouterTask::getAllJars, TheRouterTask::getAllDirectories, TheRouterTask::getOutputFile);
            }
        });
    }
}

