package cn.thearies.sugarcane.jdbc;

import java.util.List;

public class Page<T> {
    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    private long total = 0;
    private long totalPage = 0;
    private Integer pageNumber = 1;
    private Integer pageSize = 10;
    private List<T> rows;

    public List<T> getRows() {
        return rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }


    public Integer getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotalPage() {
        if (pageSize == 0) {
            return 1;
        }
        return this.total % pageSize == 0 ? total / this.pageSize : total / this.pageSize + 1;
    }

}
