package cn.thearies.sugarcane.jdbc;


import java.util.ArrayList;
import java.util.List;

public class Filter {
    /**
     * 查询条件
     */
    private List<Condition> cs = new ArrayList<>();
    /**
     * 排序条件
     */
    private List<Sort> ss = new ArrayList<>();
    private Integer pageNumber = 1;
    private Integer pageSize = 10;

    public Integer getPageSize() {
        return pageSize;
    }

    public Filter setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Integer getPageNumber() {
        return (pageNumber - 1) * pageSize;
    }

    public Filter setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public List<Condition> getCs() {
        return cs;
    }

    public Filter setCs(List<Condition> cs) {
        this.cs = cs;
        return this;

    }

    public List<Sort> getSs() {
        return ss;
    }

    public Filter setSs(List<Sort> ss) {
        this.ss = ss;
        return this;
    }

    /**
     * 添加查询条件
     *
     * @param f
     * @param o
     * @param v
     */
    public Filter addCondition(String f, Operator o, String v) {
        Condition cs = new Condition();
        cs.setF(f);
        cs.setO(o);
        cs.setV(v);
        this.cs.add(cs);
        return this;
    }

    /**
     * 添加排序条件
     *
     * @param f
     * @param o
     */
    public Filter addSort(String f, String o) {
        Sort ss = new Sort();
        ss.setF(f);
        ss.setO(o);
        this.ss.add(ss);
        return this;
    }
}
