package cn.thearies.sugarcane.jdbc;

import com.google.common.base.CaseFormat;

public class Condition {
    /**
     * 查询字段
     */
    private String f;
    /**
     * 值
     */
    private String v;
    /**
     * 操作符
     */
    private Operator o;

    public String getF() {
        return f;
    }

    public Condition setF(String f) {
        this.f = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, f);
        return this;
    }

    public String getO() {
        return o.getValue();
    }

    public Condition setO(Operator o) {
        this.o = o;
        return this;

    }

    public String getV() {
        if (" like ".equals(o.getValue()) || " not like ".equals(o.getValue())) {
            return "'%" + v + "%'";
        }
        if (" = ".equals(o.getValue()) || " != ".equals(o.getValue())) {
            return "'" + v + "'";
        }
        return v;
    }

    public Condition setV(String v) {
        String[] vs = v.split(",");
        if (vs.length == 1) {
            this.v = vs[0];
            return this;
        }
        this.v = "(" + v + ")";
        return this;

    }


}
