package cn.thearies.sugarcane.jdbc;

import org.springframework.scheduling.annotation.Async;

import java.util.Date;
import java.util.List;

public interface BaseJdbcService<T extends BasePo> {


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    T findRowById(Integer id);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Integer id);

    /**
     * @param t
     * @return
     */
    default Integer deleteById(BasePo t) {
        return this.deleteById(t.getId());
    }


    /**
     * 标识位删除
     *
     * @param id
     * @return
     */
    Integer deleteByTag(Integer id);

    /**
     * @param t
     * @return
     */
    default Integer deleteByTag(BasePo t) {
        return this.deleteByTag(t.getId());
    }


    /**
     * 保存记录保存记录
     *
     * @param t
     * @return
     */
    default T saveOrUpdate(BasePo t) {
        Integer id = t.getId();
        if (id == null) {
            Date now = new Date();
            t.setCreateddate(now);
            t.setLastmodifieddate(now);
            this.baseSaveOrUpdate(t);
            return (T) t;
        }
        this.baseSaveOrUpdate(t);
        t = this.findRowById(id);
        return (T) t;
    }


    /**
     * 批量保存/修改
     *
     * @param ts
     * @return
     */
    default Integer saveOrUpdateBatch(List<T> ts) {
        Integer tempCount = 0;
        Integer tempId = 0;
        for (BasePo t : ts) {
            tempId = t.getId();
            if (tempId == null) {
                Date now = new Date();
                t.setCreateddate(now);
                t.setLastmodifieddate(now);
                tempCount += this.baseSaveOrUpdate(t);
            } else {
                tempCount += this.baseSaveOrUpdate(t);
            }
        }
        return tempCount;
    }


    /**
     * 基础修改/新增
     *
     * @param t
     * @return
     */
    Integer baseSaveOrUpdate(BasePo t);

    /**
     * 记录列表
     *
     * @param filter
     * @return
     */
    List<T> findRows(Filter filter);


    /**
     * 记录总条数
     *
     * @return
     */
    long countTotal(Filter filter);


    /**
     * 查询单条
     *
     * @param filter
     * @return
     */
    default T findRowByFilter(Filter filter) {
        List<T> rows = this.findRows(filter);
        if (rows.size() == 0) {
            return null;
        }
        return rows.get(0);
    }


    /**
     * 查询所有
     *
     * @param filter
     * @return
     */
    default List<T> findListByFilter(Filter filter) {
        if (filter == null) {
            filter = new Filter();
        }
        filter.setPageSize(0);
        List<T> rows = this.findRows(filter);
        return rows.size() == 0 ? null : rows;
    }


    /**
     * 查询所有 deltag == 0
     *
     * @param filter
     * @return
     */
    default List<T> findListByFilterClose(Filter filter) {
        if (filter == null) {
            filter = new Filter();
        }
        filter.setPageSize(0);
        filter.addCondition("deltag", Operator.EQ, "0");
        List<T> rows = this.findRows(filter);
        return rows.size() == 0 ? null : rows;
    }


    /**
     * 分页
     *
     * @param filter
     * @return
     */
    default Page findPageByFilter(Filter filter) {
        if (filter == null) {
            filter = new Filter();
        }
        List rows = this.findRows(filter);
        if (rows.size() == 0) {
            return null;
        }
        Page page = new Page();
        page.setTotal(this.countTotal(filter));
        Integer pageSize = filter.getPageSize();
        if (pageSize == 0) {
            page.setPageNumber(1);
        } else {
            page.setPageNumber(filter.getPageNumber() / pageSize + 1);

        }
        page.setPageSize(filter.getPageSize());
        page.setRows(rows);
        return page;

    }


    /**
     * 查询所有 deltag == 0
     * 分页
     *
     * @param filter
     * @return
     */
    default Page findPageByFilterClose(Filter filter) {
        if (filter == null) {
            filter = new Filter();
        }
        filter.addCondition("deltag", Operator.EQ, "0");
        List rows = this.findRows(filter);
        if (rows.size() == 0) {
            return null;
        }
        Page page = new Page();
        page.setTotal(this.countTotal(filter.addCondition("deltag", Operator.EQ, "0")));
        Integer pageSize = filter.getPageSize();
        if (pageSize == 0) {
            page.setPageNumber(1);
        } else {
            page.setPageNumber(filter.getPageNumber() / pageSize + 1);

        }
        page.setPageSize(filter.getPageSize());
        page.setRows(rows);
        return page;
    }


}
