package cn.thearies.sugarcane.exception.enums;

public enum ResultCodeEnum {

	OK(0, MessageEnum.RESULT_CODE_OK.getValue()), 
	BIZ_ERROR(1, null), 
	FRAMEWORK_ERROR(2, null), 
	TOKEN_EXPIRED(3, MessageEnum.RESULT_CODE_TOKEN_EXPIRED_ERROR.getValue()),
	TOKEN_SIGNATURE_FAILED(4, MessageEnum.RESULT_CODE_TOKEN_SIGNATURE_FAILED.getValue()),
	SERVICE_NOT_ACCEPTABLE(5, null),
	NO_PERMISSION(403, MessageEnum.RESULT_CODE_NO_PERMISSION_ERROR.getValue()), 
	NOT_FOUND(404, MessageEnum.RESULT_CODE_NOT_FOUND_ERROR.getValue()), 
	SERVER_ERROR(500, MessageEnum.RESULT_CODE_SERVER_ERROR.getValue()),
	UNKNOWN_ERROR(-1, MessageEnum.RESULT_CODE_UNKNOWN_ERROR.getValue())
	;

	private int code;
	private String msg;

	private ResultCodeEnum(int code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}
}
