package cn.thearies.sugarcane.exception;


import cn.thearies.sugarcane.exception.enums.ResultCodeEnum;
import cn.thearies.sugarcane.util.JsonUtil;
import cn.thearies.sugarcane.util.ResultDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;


public class BaseGlobalExceptionHandler {

	private final static Logger logger = LoggerFactory.getLogger(BaseGlobalExceptionHandler.class);

	@ExceptionHandler({ Exception.class })
	public ResultDto<Object> exception(Exception exception) {
		logger.error(null, exception);
		ResultDto<Object> result = new ResultDto<Object>();
		result.setCode(ResultCodeEnum.SERVER_ERROR.getCode());
		result.setMsg(exception.getMessage());
		logger.info("Response Data    : " + JsonUtil.toJson(result));
		logger.info("*****************************************************************************");
		return result;
	}
	
	@ExceptionHandler({ NoHandlerFoundException.class })
	public ResultDto<Object> exception(NoHandlerFoundException exception) {
		logger.error(null, exception);
		ResultDto<Object> result = new ResultDto<Object>();
		result.setCode(ResultCodeEnum.NOT_FOUND.getCode());
		result.setMsg(ResultCodeEnum.NOT_FOUND.getMsg());
		logger.info("Response Data    : " + JsonUtil.toJson(result));
		logger.info("*****************************************************************************");
		return result;
	}

	@ExceptionHandler({ BizException.class })
	public ResultDto<Object> bizException(BizException exception) {
		ResultDto<Object> result = new ResultDto<Object>();
		result.setCode(ResultCodeEnum.BIZ_ERROR.getCode());
		result.setMsg(exception.getMessage());
		logger.info("Response Data    : " + JsonUtil.toJson(result));
		logger.info("*****************************************************************************");
		return result;
	}

	@ExceptionHandler({ FrameworkException.class })
	public ResultDto<Object> frameworkException(FrameworkException exception) {
		logger.error(null, exception);
		ResultDto<Object> result = new ResultDto<Object>();
		result.setCode(ResultCodeEnum.FRAMEWORK_ERROR.getCode());
		result.setMsg(exception.getMessage());
		logger.info("Response Data    : " + JsonUtil.toJson(result));
		logger.info("*****************************************************************************");
		return result;
	}

	@ExceptionHandler({ TokenSignatureException.class })
	public ResultDto<Object> tokenSignatureException(TokenSignatureException exception) {
		logger.error(null, exception);
		ResultDto<Object> result = new ResultDto<Object>();
		result.setCode(ResultCodeEnum.TOKEN_SIGNATURE_FAILED.getCode());
		result.setMsg(ResultCodeEnum.TOKEN_SIGNATURE_FAILED.getMsg());
		logger.info("Response Data    : " + JsonUtil.toJson(result));
		logger.info("*****************************************************************************");
		return result;
	}

	@ExceptionHandler({ TokenExpiredException.class })
	public ResultDto<Object> tokenExpiredException(TokenExpiredException exception) {
		logger.error(null, exception);
		ResultDto<Object> result = new ResultDto<Object>();
		result.setCode(ResultCodeEnum.TOKEN_EXPIRED.getCode());
		result.setMsg(ResultCodeEnum.TOKEN_EXPIRED.getMsg());
		logger.info("Response Data    : " + JsonUtil.toJson(result));
		logger.info("*****************************************************************************");
		return result;
	}

	@ExceptionHandler({CustMadeException.class})
	public ResultDto<Object> custMadeException(CustMadeException exception) {
		logger.error(null, exception);
		ResultDto<Object> result = new ResultDto<Object>();
		result.setCode(exception.getCode());
		result.setMsg(exception.getMessage());
		logger.info("Response Data    : " + JsonUtil.toJson(result));
		logger.info("*****************************************************************************");
		return result;
	}

}
