package cn.openx.boot.framework.booster.web.result;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.openx.boot.framework.booster.web.code.BaseCode;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

import java.beans.Transient;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * @author zhanls 2021/11/3 23:28
 * @version 1.0
 * @Description - API接口返回结果抽象类
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonPropertyOrder({"code", "message", "data"})
@Slf4j
public abstract class ApiCoreResult<E> {

    /**
     * 业务响应码
     */
    @ApiModelProperty(value = "业务响应码=200 成功")
    @NonNull
    protected String code;

    /**
     * 响应码的具体说明信息
     */
    @ApiModelProperty(value = "响应码的具体说明信息")
    @NonNull
    protected String message;

    /**
     * 业务数据
     */
    @ApiModelProperty(value = "业务数据")
    protected E data;


    @Transient
    protected BaseCode[] getOkCodes(){
        return new BaseCode[]{BaseCode.SUCCESS};
    }

    /**
     * 将异常堆栈进行格式化输出
     *
     * @param
     * @return
     * @updateRecord - 初次创建
     * @version 1.0 (2019年11月10日) wangj
     */
    public E getData() {
        if (data instanceof Exception) {
            try {
                Throwable exceptionData = ((Throwable) data);
                //堆栈转为完整字符串
                String stackTraceContent = StrUtil.concat(true, "\n message:", ExceptionUtil.getMessage(exceptionData), "\n stacktrace:", ExceptionUtil.stacktraceToString(exceptionData));
                data = (E) stackTraceContent;
            } catch (Exception e) {
                log.error("将异常堆栈进行格式化输出，发生异常 {} ", e);
            }
        }
        return data;
    }

    @Transient
    public boolean isSuccess() {
        return Stream.of(getOkCodes()).anyMatch(respOKCode -> Objects.equals(this.code, respOKCode.getCode()));
    }

    @Transient
    public boolean isError() {
        return !isSuccess();
    }



}
