package cn.openx.boot.framework.booster.web.code;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author zhanls 2021/11/3 23:28
 * @version 1.0
 * @Description - 基础
 **/
@Getter
@AllArgsConstructor
public enum BaseCode {

    /**
     * 200 SUCCESS
     */
    SUCCESS("200", "成功", 200),

    /**
     * 4xx 客户端异常
     */
    CLIENT_BAD_REQUEST("400", "请求参数错误", 400),
    CLIENT_UNAUTHORIZED("401", "未授权", 401),
    CLIENT_FORBIDDEN("403", "拒绝访问", 403),
    CLIENT_NOT_FOUND("404", "URI Not Found", 404),
    CLIENT_METHOD_NOT_ALLOWED("405", "请求方法错误", 405),
    CLIENT_NOT_ACCEPTABLE("406", "Not Acceptable", 406),
    CLIENT_UNSUPPORTED_MEDIA_TYPE("406", "不支持的请求头类型", 415),

    /**
     * 5xx 服务器异常
     */
    SERVER_ERROR("500", "当前服务不可用，请稍后重试", 500),
    SERVICE_UNAVAILABLE("503", "当前服务不可用，请稍后重试", 503),

    /**
     * 6xx 自定义技术响应码
     */
    TECH_INVOKE_OUTSIDE_EXCEPTION("601","调用外部接口发生异常",601),
    TECH_HTTP_MESSAGE_NOT_READABLE_ERROR("602","JSON体格式序列化错误异常",602),

    /**
     * 7xx 自定义业务响应码
     */
    BIZ_SMS_SEND_EXCEPTION("701","短信验证码发送异常",701),
    BIZ_LOGIN_EXCEPTION("702","登录异常",702),
    BIZ_ADD_ASSOCIATED_EXCEPTION("703","添加连带被保险人异常",703),
    BIZ_QUERY_INSURANCE_EXCEPTION("704","核保发生异常",704),
    BIZ_SUBMIT_INSURANCE_EXCEPTION("705","投保发生异常",705),
    BIZ_CANCEL_APPLY_EXCEPTION("706","撤销保单发生异常",706),


    ;

    private String code;
    private String message;
    private int status;

    public static BaseCode parse(int status) {
        return Stream.of(values()).filter(baseCode -> baseCode.getStatus() == status).findFirst().orElse(SERVER_ERROR);
    }

}
