package cn.openx.boot.framework.booster.util.dto;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.reflect.FieldUtils;

import java.lang.reflect.Field;

/**
 * @author zhanls 2021/11/4 22:50
 * @version 1.0
 * @Description - Dto 工具类
 **/
@Slf4j
public class DtoUtils {

    /**
     *  将DTO中的空字符串属性置为NULL
     *
     * @param source
     * @return T
     * @version 1.0 2021/11/4 22:50 zhanls
     */
    public static <T> T setNullValue(T source) {
        try {

            // 此方法不能获取到父类的字段，父类的id=""字段传入进来后，不能设置null值，导致查询数据时将id=""作为查询条件，无法查到数据
            // Field[] fields = source.getClass().getDeclaredFields();

            // 此方法获取所有字段，包含本类和父类
            Field[] fields = FieldUtils.getAllFields(source.getClass());
            for (Field field : fields) {
                if (field.getGenericType().toString().equals("class java.lang.String")) {
                    field.setAccessible(true);
                    Object obj = field.get(source);
                    if (obj != null && obj.equals("")) {
                        field.set(source, null);
                    }
                }
            }
        } catch (Exception e) {
            log.error("DtoUtil.setNullValue exception{}", e);
        }
        return source;
    }

}
