package cn.openx.boot.framework.booster.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhanls 2021/11/4 00:14
 * @version 1.0
 * @Description - 提取了表设计规范中的基础属性的DTO基类，所有DTO都必须继承此类
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BaseDTO implements Serializable {

    private static final long serialVersionUID = -93658146137270498L;
    /** 主键 */
    @ApiModelProperty(value = "主键" ,hidden = true)
    private String id;

    /** 创建人 */
    @ApiModelProperty(value = "创建人",hidden = true)
    private String createOpr;

    /** 创建时间 */
    @ApiModelProperty(value = "创建时间",hidden = true)
    private Date dateCreate;

    /** 修改人 */
    @ApiModelProperty(value = "修改人",hidden = true)
    private String modifyOpr;

    /** 修改时间 */
    @ApiModelProperty(value = "修改时间",hidden = true)
    private Date dateModify;

    /** 是否生效 1：生效，0：失效 */
    @ApiModelProperty(value = "是否生效 1：生效，0：失效",hidden = true)
//    @JsonIgnore
    private String isValid;

    /** 是否删除 1：删除，0：未删除 */
    @ApiModelProperty(value = "是否删除 1：删除，0：未删除",hidden = true)
//    @JsonIgnore
    private String isDelete;

    /** 查询模式：默认：精确匹配；like:左右模糊；leftLike:%左模糊；rightLike :右模糊%*/
    @ApiModelProperty(value = "查询模式：like:左右模糊；leftLike:%左模糊；rightLike :右模糊%",hidden = true)
    @JsonIgnore
    private String searchType;
}
