package cn.openx.boot.framework.booster.web.exception;

import cn.openx.boot.framework.booster.web.code.BaseCode;
import lombok.Getter;

import static java.lang.String.format;

/**
 * @author zhanls 2021/11/3 23:57
 * @version 1.0
 * @Description - API异常类
 **/
public class ApiException extends RuntimeException {

    @Getter
    private String code;

    public ApiException(BaseCode code) {
        super(code.getMessage());
        this.code = code.getCode();
    }

    public ApiException(BaseCode code, Object... args) {
        super(format(code.getMessage(), args));
        this.code = code.getCode();
    }

    public ApiException(String message, BaseCode code, Object... args) {
        super(format(message == null ? code.getMessage() : message, args));
        this.code = code.getCode();
    }
}
