package cn.openx.boot.framework.booster.util.base;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.json.JSONUtil;
//import com.alibaba.fastjson.JSON;


import java.lang.reflect.Type;

/**
 * 转换服务工具类（基于hutool）
 *
 * @version 1.0
 */
public class ConvertUtils {

    /**
     * 转换值为指定类型
     *
     * @param <T>   目标类型
     * @param type  类型
     * @param value 值
     * @return 转换后的值
     * @throws ConvertException 转换器不存在
     * @since 4.0.0
     */
    public static <T> T convert(Class<T> type, Object value) throws ConvertException {
        if (isJson(value)) {
            return JSONUtil.toBean(String.valueOf(value),type);
//            return JSON.parseObject(String.valueOf(value),type);
        }
        return Convert.convert(type, value);
    }

    /**
     * 是否为JSON字符串
     *
     * @param value 判断对象
     * @return
     * @updateRecord - 初次创建
     * @version 1.0 (2019年11月19日) wangj
     */
    public static boolean isJson(Object value) {
        if (value instanceof String) {
            String valueStr = String.valueOf(value);
            if (JSONUtil.isJson(valueStr)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 转换值为指定类型
     *
     * @param <T>       目标类型
     * @param reference 类型参考，用于持有转换后的泛型类型
     * @param value     值
     * @return 转换后的值
     * @throws ConvertException 转换器不存在
     */
    public static <T> T convert(TypeReference<T> reference, Object value) throws ConvertException {
        return Convert.convert(reference, value);
    }

    /**
     * 转换值为指定类型
     *
     * @param <T>   目标类型
     * @param type  类型
     * @param value 值
     * @return 转换后的值
     * @throws ConvertException 转换器不存在
     */
    public static <T> T convert(Type type, Object value) throws ConvertException {
        if (isJson(value)) {
            return JSONUtil.toBean(String.valueOf(value),type,false);
//            return JSON.parseObject(String.valueOf(value),type);

        }
        return Convert.convert(type, value);
    }

    /**
     * 转换值为指定类型
     *
     * @param <T>          目标类型
     * @param type         类型
     * @param value        值
     * @param defaultValue 默认值
     * @return 转换后的值
     * @throws ConvertException 转换器不存在
     * @since 4.0.0
     */
    public static <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return Convert.convert(type, value, defaultValue);
    }

    /**
     * 转换值为指定类型
     *
     * @param <T>          目标类型
     * @param type         类型
     * @param value        值
     * @param defaultValue 默认值
     * @return 转换后的值
     * @throws ConvertException 转换器不存在
     */
    public static <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return Convert.convert(type, value, defaultValue);
    }

}
