package cn.openx.boot.framework.booster.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhanls 2021/11/4 00:17
 * @version 1.0
 * @Description - 提取了表设计规范中的基础属性的Entity基类，所有entity都必须继承此类
 **/
@Data
public class BaseEntity implements Serializable {

    private static final long serialVersionUID = -6097968643931862242L;
    /** ID */
    @Column(name="ID")
    @Id
    private String id;
    /** 是否删除 */
    @Column(name="IS_DELETE")
    private String isDelete;
    /** 是否生效 */
    @Column(name="IS_VALID")
    private String isValid;
    /** 修改人 */
    @Column(name="MODIFY_OPR")
    private String modifyOpr;
    /** 修改时间 */
    @Column(name="DATE_MODIFY")
    private Date dateModify;
    /** 创建时间 */
    @Column(name="DATE_CREATE")
    private Date dateCreate;
    /** 创建人 */
    @Column(name="CREATE_OPR")
    private String createOpr;
    /** 查询模式：默认：精确匹配；like:左右模糊；leftLike:%左模糊；rightLike :右模糊%*/
    @Transient
    private String searchType;


}
