/*
 * Decompiled with CFR 0.152.
 */
package cn.openx.boot.framework.booster.web.result;

import cn.hutool.core.util.NumberUtil;
import cn.openx.boot.framework.booster.web.code.BaseCode;
import cn.openx.boot.framework.booster.web.exception.ApiException;
import cn.openx.boot.framework.booster.web.result.ApiCoreResult;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiResult<E>
extends ApiCoreResult<E> {
    private static final Logger log = LoggerFactory.getLogger(ApiResult.class);

    public static <E> ApiResult<E> ok() {
        return ApiResult.ok(null);
    }

    public static <E> ApiResult<E> ok(E data) {
        return ApiResult.build((BaseCode)BaseCode.SUCCESS, data);
    }

    public static <E> ApiResult<E> err(BaseCode code) {
        return ApiResult.err((BaseCode)code, (String)code.getMessage());
    }

    public static <E> ApiResult<E> err(BaseCode code, String message) {
        return ApiResult.err((String)code.getCode(), (String)message);
    }

    public static <E> ApiResult<E> err(String message) {
        return ApiResult.err((String)BaseCode.SERVER_ERROR.getCode(), (String)message);
    }

    public static <E> ApiResult<E> err(String message, String data) {
        if (NumberUtil.isNumber((CharSequence)message)) {
            BaseCode baseCode = BaseCode.parse((int)Integer.valueOf(message));
            if (!BaseCode.SERVER_ERROR.getCode().equals(baseCode.getCode())) {
                return ApiResult.build((String)baseCode.getCode(), (String)baseCode.getMessage(), (Object)data);
            }
            return ApiResult.build((String)message, (String)data, (Object)data);
        }
        return ApiResult.build((String)BaseCode.SERVER_ERROR.getCode(), (String)message, (Object)data);
    }

    public static <E> ApiResult<E> build(BaseCode code, E data) {
        return ApiResult.build((String)code.getCode(), (String)code.getMessage(), data);
    }

    public static <E> ApiResult<E> build(String code, String message, E data) {
        return new ApiResult(code, message, data);
    }

    public static <E> ApiResult<E> err(String message, E data) {
        return ApiResult.build((String)BaseCode.SERVER_ERROR.getCode(), (String)message, data);
    }

    public static <E> ApiResult<E> err(BaseCode code, E data) {
        return ApiResult.build((String)code.getCode(), (String)code.getMessage(), data);
    }

    public static <E> ApiResult<E> build(BaseCode code) {
        return ApiResult.build((BaseCode)code, null);
    }

    public static <E> ApiResult<E> with(Throwable e) {
        if (e != null && e instanceof ApiException) {
            return ApiResult.err((String)((ApiException)e).getCode(), (String)e.getMessage());
        }
        if (e != null) {
            return ApiResult.err((BaseCode)BaseCode.SERVER_ERROR, (String)e.getMessage());
        }
        return ApiResult.err((BaseCode)BaseCode.SERVER_ERROR);
    }

    @ConstructorProperties(value={"code", "message", "data"})
    public ApiResult(String code, String message, E data) {
        super(code, message, data);
        if (!BaseCode.SUCCESS.getCode().equals(code)) {
            log.error("message : {} ", (Object)message);
            log.error("data: {} ", data);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResult)) {
            return false;
        }
        ApiResult other = (ApiResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResult;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "ApiResult(super=" + super.toString() + ")";
    }

    public ApiResult() {
    }
}

